/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream {
    private final int limit;
    private int remains;
    private static final String EXCEPTION_MSG = "Over size limit (limit: %d bytes, trying: %d bytes).";

    public LimitedOutputStream(OutputStream out, int size) {
        super(out);
        this.limit = size;
        this.remains = size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this.remains) {
            throw new IOException(String.format(EXCEPTION_MSG, this.limit, this.limit - this.remains + len));
        }
        this.out.write(b, off, len);
        this.remains -= len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remains == 0) {
            throw new IOException(String.format(EXCEPTION_MSG, this.limit, this.limit + 1));
        }
        this.out.write(b);
        --this.remains;
    }

    @Override
    public void close() throws IOException {
        while (this.remains-- > 0) {
            this.out.write(0);
        }
        super.close();
    }

    public int remains() {
        return this.remains;
    }
}

