/*
 * Decompiled with CFR 0.152.
 */
package nor.core.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;

public abstract class Plugin
implements Closeable {
    protected final Properties properties = new Properties();

    public final void load(File dir) {
        File conf = new File(dir, String.format("%s.conf", this.getClass().getCanonicalName()));
        if (conf.exists()) {
            try {
                this.properties.load(new FileInputStream(conf));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.init();
    }

    public final void save(File dir) {
        File conf = new File(dir, String.format("%s.conf", this.getClass().getCanonicalName()));
        try {
            this.properties.store(new FileOutputStream(conf), "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init() {
    }

    @Override
    public void close() {
    }

    public MessageHandler[] messageHandlers() {
        return null;
    }

    public RequestFilter[] requestFilters() {
        return null;
    }

    public ResponseFilter[] responseFilters() {
        return null;
    }
}

