/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import nor.core.plugin.Plugin;
import nor.core.proxy.ProxyHandler;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.http.server.HttpServer;
import nor.http.server.nserver.HttpNServer;
import nor.util.log.EasyLogger;

public class ProxyServer
implements Closeable {
    private final HttpServer server;
    private final ProxyHandler handler;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ProxyServer.class);

    public ProxyServer(String name) {
        LOGGER.entering("<init>", name);
        assert (name != null);
        this.handler = new ProxyHandler(name, "1.1");
        this.server = new HttpNServer(this.handler);
        LOGGER.exiting("<init>");
    }

    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, (Object)port);
        assert (hostname != null && hostname.length() != 0);
        assert (port > 0);
        this.server.start(hostname, port);
        LOGGER.exiting("start");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.server.close();
        LOGGER.exiting("close");
    }

    public void attach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        int n;
        LOGGER.entering("attach", plugin);
        LOGGER.info("Loading a plugin (" + plugin.getClass().getName() + ")");
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            MessageHandler[] messageHandlerArray = hs;
            n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                MessageHandler h = messageHandlerArray[n2];
                this.handler.attach(h);
                ++n2;
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            RequestFilter[] requestFilterArray = rqs;
            int n3 = rqs.length;
            n = 0;
            while (n < n3) {
                RequestFilter f = requestFilterArray[n];
                this.handler.attach(f);
                ++n;
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            ResponseFilter[] responseFilterArray = res;
            int n4 = res.length;
            int n5 = 0;
            while (n5 < n4) {
                ResponseFilter f = responseFilterArray[n5];
                this.handler.attach(f);
                ++n5;
            }
        }
        LOGGER.exiting("attach");
    }

    public void detach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        int n;
        LOGGER.entering("detach", plugin);
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            MessageHandler[] messageHandlerArray = hs;
            n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                MessageHandler h = messageHandlerArray[n2];
                this.handler.detach(h);
                ++n2;
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            RequestFilter[] requestFilterArray = rqs;
            int n3 = rqs.length;
            n = 0;
            while (n < n3) {
                RequestFilter f = requestFilterArray[n];
                this.handler.detach(f);
                ++n;
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            ResponseFilter[] responseFilterArray = res;
            int n4 = res.length;
            int n5 = 0;
            while (n5 < n4) {
                ResponseFilter f = responseFilterArray[n5];
                this.handler.detach(f);
                ++n5;
            }
        }
        LOGGER.exiting("detach");
    }

    public void addRouting(Pattern pat, URL extProxyHost) {
        LOGGER.entering("addRouting", pat, extProxyHost);
        assert (pat != null);
        assert (extProxyHost != null);
        this.handler.addRouting(pat, extProxyHost);
        LOGGER.exiting("addRouting");
    }

    public void removeRouting(Pattern pat) {
        LOGGER.entering("removeRouting", pat);
        assert (pat != null);
        this.handler.removeRouting(pat);
        LOGGER.exiting("removeRouting");
    }

    public static void main(String[] args) {
        ProxyServer app = new ProxyServer("nor");
        try {
            if (args.length < 2) {
                System.err.println("Usage: <bind address> <listen port> [<external proxy url>]");
                System.exit(1);
            }
            if (args.length >= 3) {
                app.addRouting(Pattern.compile(".*"), new URL(args[2]));
            }
            app.start(args[0], Integer.parseInt(args[1]));
            System.in.read();
            app.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

