/*
 * Decompiled with CFR 0.152.
 */
package nor.http.error;

import java.io.ByteArrayInputStream;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;

public class HttpException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Status status;
    private final String message;
    protected final Throwable cause;

    public HttpException(Status status) {
        this(status, null, null);
    }

    public HttpException(Status status, String message) {
        this(status, message, null);
    }

    public HttpException(Status status, Throwable cause) {
        this(status, null, cause);
    }

    public HttpException(Status status, String message, Throwable cause) {
        this.status = status;
        this.message = message;
        this.cause = cause;
    }

    public HttpResponse createResponse(HttpRequest request) {
        HttpResponse ret = request.createResponse(Status.valueOf(this.status.getCode()));
        HttpHeader header = ret.getHeader();
        if (this.message != null) {
            byte[] msg = this.message.getBytes();
            header.add(HeaderName.ContentLength, Integer.toString(msg.length));
            header.add(HeaderName.Server, "Nor");
            ret.getBody().setStream(new ByteArrayInputStream(msg));
        } else {
            header.add(HeaderName.ContentLength, "0");
            header.add(HeaderName.Server, "Nor");
        }
        assert (ret != null);
        return ret;
    }
}

