/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FixedSizeMap<Key, Value>
implements Map<Key, Value> {
    private final int limit;
    private final LinkedList<Map.Entry<Key, Value>> elem = new LinkedList();

    public FixedSizeMap(int limit) {
        this.limit = limit;
    }

    @Override
    public Value put(Key key, Value value) {
        if (this.size() == this.limit) {
            this.elem.removeLast();
        }
        this.elem.addFirst(new AbstractMap.SimpleEntry<Key, Value>(key, value));
        return value;
    }

    public Map.Entry<Key, Value> find(Object key) {
        for (Map.Entry entry : this.elem) {
            if (!key.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Value get(Object key) {
        Map.Entry<Key, Value> res = this.find(key);
        if (res != null) {
            return res.getValue();
        }
        return null;
    }

    @Override
    public Value remove(Object key) {
        Map.Entry<Key, Value> res = this.find(key);
        if (res != null) {
            this.elem.remove(res);
            return res.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        for (Key key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.find(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry entry : this.elem) {
            if (!value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elem.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elem.isEmpty();
    }

    @Override
    public void clear() {
        this.elem.clear();
    }

    @Override
    public Set<Key> keySet() {
        HashSet ret = new HashSet();
        for (Map.Entry entry : this.elem) {
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public Collection<Value> values() {
        ArrayList ret = new ArrayList();
        for (Map.Entry entry : this.elem) {
            ret.add(entry.getValue());
        }
        return ret;
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        HashSet<Map.Entry<Key, Value>> ret = new HashSet<Map.Entry<Key, Value>>();
        for (Map.Entry entry : this.elem) {
            ret.add(entry);
        }
        return ret;
    }
}

