/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.io.IOException;
import java.io.InputStream;
import nor.util.SequentialInputStream;

public class LimitedInputStream
extends SequentialInputStream {
    private int remains;

    public LimitedInputStream(InputStream in, int size) {
        super(in);
        this.remains = size;
    }

    @Override
    public int read() throws IOException {
        if (this.remains == 0) {
            return -1;
        }
        --this.remains;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = -1;
        if (this.remains != 0 && (ret = this.in.read(b, off, Math.min(this.remains, len))) != -1) {
            this.remains -= ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = 0L;
        if (n > 0L) {
            if (n > (long)this.remains) {
                ret = this.remains;
                this.remains = 0;
            } else {
                ret = n;
                this.remains -= (int)n;
            }
            this.in.skip(ret);
        }
        return ret;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.remains);
    }

    public int remains() {
        return this.remains;
    }
}

