/*
 * Decompiled with CFR 0.152.
 */
package nor.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class Stream {
    public static int DEFAULT_BUFFER_SIZE = 65536;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        Stream.copy(in, out, DEFAULT_BUFFER_SIZE);
    }

    public static void copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        ReadableByteChannel cin = Channels.newChannel(in);
        WritableByteChannel cout = Channels.newChannel(out);
        Stream.copy(cin, cout, bufSize);
    }

    public static void copy(ReadableByteChannel in, WritableByteChannel out, int bufSize) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(bufSize);
        long c = 0L;
        block0: while (true) {
            buf.clear();
            if (in.read(buf) < 0) break;
            buf.flip();
            int len = buf.limit() - buf.position();
            c += (long)len;
            while (true) {
                if (len == 0) continue block0;
                len -= out.write(buf);
            }
            break;
        }
    }
}

