/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.nserver.ListenWorker;
import nor.util.log.EasyLogger;

public class HttpNServer
implements HttpServer {
    public static final String VERSION = "1.1";
    private final HttpRequestHandler handler;
    private ListenWorker listener;
    private Thread listenThread;
    private final int minThreads = 4;
    private final int queueSize = 3;
    private final int waitTime = 6000;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(HttpNServer.class);

    public HttpNServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, (Object)port);
        this.listener = new ListenWorker(hostname, port, this.handler, 4, 3, 6000);
        this.listenThread = new Thread(this.listener);
        this.listenThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        if (this.listener != null) {
            this.listener.close();
            try {
                this.listenThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.throwing("close", e);
            }
        }
        LOGGER.exiting("close");
    }
}

