/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import nor.http.HeaderName;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.NoExceptionOutputStreamFilter;
import nor.util.log.EasyLogger;

class ServiceWorker
implements Runnable,
Closeable {
    private final Queue<Connection> queue;
    private final HttpRequestHandler handler;
    private boolean running = true;
    private static int nThreads = 0;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ServiceWorker.class);

    private ServiceWorker(Queue<Connection> queue, HttpRequestHandler handler) {
        this.queue = queue;
        this.handler = handler;
    }

    @Override
    public synchronized void run() {
        LOGGER.entering("run", new Object[0]);
        while (this.running) {
            Connection con = this.queue.poll();
            if (con == null) break;
            LOGGER.finest(String.valueOf(Thread.currentThread().getName()) + " begins to handle the " + con);
            BufferedInputStream input = new BufferedInputStream(con.getInputStream());
            BufferedOutputStream output = new BufferedOutputStream(new NoExceptionOutputStreamFilter(con.getOutputStream()));
            try {
                boolean keepAlive = true;
                String prefix = "";
                HttpRequest request = HttpRequest.create(input, prefix);
                if (request == null) {
                    LOGGER.finest(String.valueOf(Thread.currentThread().getName()) + " receives a null request");
                    keepAlive = false;
                } else {
                    LOGGER.finest(String.valueOf(Thread.currentThread().getName()) + " receives the " + request);
                    keepAlive &= this.isKeepingAlive(request);
                    HttpResponse response = this.handler.doRequest(request);
                    keepAlive &= this.isKeepingAlive(response);
                    try {
                        LOGGER.info(String.valueOf(request.getHeadLine()) + " > " + response.getHeadLine() + " (" + response.getHeader().get(HeaderName.ContentLength) + " bytes)");
                        response.output(output);
                        ((OutputStream)output).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println(response.getHeadLine());
                        System.out.println(response.getHeader().toString());
                    }
                }
                if (keepAlive) {
                    LOGGER.finest(String.valueOf(Thread.currentThread().getName()) + " requeues the " + con);
                    this.queue.add(con);
                    continue;
                }
                LOGGER.finest(String.valueOf(Thread.currentThread().getName()) + " finishes to handle and closes the " + con);
                ((InputStream)input).close();
                ((OutputStream)output).close();
                con.close();
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
                try {
                    ((InputStream)input).close();
                    ((OutputStream)output).close();
                    con.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    ((InputStream)input).close();
                    ((OutputStream)output).close();
                    con.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        ServiceWorker.decrease();
        LOGGER.exiting("run");
    }

    private boolean isKeepingAlive(HttpRequest request) {
        return !request.getHeader().containsValue(HeaderName.Connection, "close");
    }

    private boolean isKeepingAlive(HttpResponse response) {
        return !response.getHeader().containsValue(HeaderName.Connection, "close");
    }

    @Override
    public void close() throws IOException {
        this.running = false;
    }

    public static synchronized ServiceWorker create(Queue<Connection> queue, HttpRequestHandler handler) {
        ++nThreads;
        return new ServiceWorker(queue, handler);
    }

    public static synchronized int nThreads() {
        return nThreads;
    }

    private static synchronized void decrease() {
        --nThreads;
    }
}

