/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import nor.http.server.HttpRequestHandler;
import nor.http.server.tserver.ServiceWorker;
import nor.util.log.EasyLogger;

final class ListenWorker
implements Runnable,
Closeable {
    private final ServerSocket socket;
    private final HttpRequestHandler handler;
    private final ExecutorService pool;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ListenWorker.class);

    ListenWorker(ServerSocket socket, HttpRequestHandler handler, int nThreads) {
        LOGGER.entering("<init>", socket, handler, nThreads);
        assert (socket != null);
        assert (handler != null);
        assert (nThreads >= 0);
        this.socket = socket;
        this.handler = handler;
        this.pool = nThreads == 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(nThreads);
        LOGGER.exiting("<init>");
    }

    @Override
    public void run() {
        LOGGER.entering("run", new Object[0]);
        try {
            Socket socket = this.socket.accept();
            while (socket != null) {
                this.pool.execute(new ServiceWorker(socket, this.handler));
                socket = this.socket.accept();
            }
        }
        catch (SocketException e) {
            LOGGER.info("\u30b5\u30fc\u30d0\u306e\u5f85\u3061\u53d7\u3051\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f");
        }
        catch (IOException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        LOGGER.exiting("run");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.pool.shutdownNow();
        try {
            try {
                this.pool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            this.socket.close();
        }
        LOGGER.exiting("close");
    }
}

