/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import nor.util.io.SequentialInputStream;

public class CopyingInputStream
extends SequentialInputStream {
    private final ByteArrayOutputStream _copy = new ByteArrayOutputStream();

    public CopyingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret != -1) {
            this._copy.write(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        if (ret != -1) {
            this._copy.write(b, off, ret);
        }
        return ret;
    }

    public byte[] getCopy() {
        return this._copy.toByteArray();
    }
}

