/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.nserver.ListenWorker;
import nor.util.log.EasyLogger;

public class HttpNServer
implements HttpServer {
    public static final String VERSION = "1.1";
    private final HttpRequestHandler handler;
    private ListenWorker listener;
    private Thread listenThread;
    private final int minThreads;
    private final int queueSize;
    private final int timeout;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(HttpNServer.class);
    private static final String DefaultMinThreads = "4";
    private static final String DefaultQueueSize = "3";
    private static final String DefaultTimeout = "300000";
    private static final String KeyTemplate = "%s.%s";
    private static final String MinThreadsKey = "minThreads";
    private static final String QueueSizeKey = "querySize";
    private static final String TimeoutKey = "timeout";

    public HttpNServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        String classname = this.getClass().getName();
        this.minThreads = Integer.valueOf(System.getProperty(String.format(KeyTemplate, classname, MinThreadsKey), DefaultMinThreads));
        this.queueSize = Integer.valueOf(System.getProperty(String.format(KeyTemplate, classname, QueueSizeKey), DefaultQueueSize));
        this.timeout = Integer.valueOf(System.getProperty(String.format(KeyTemplate, classname, TimeoutKey), DefaultTimeout));
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, (Object)port);
        this.listener = new ListenWorker(hostname, port, this.handler, this.minThreads, this.queueSize, this.timeout);
        this.listenThread = new Thread(this.listener);
        this.listenThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        if (this.listener != null) {
            this.listener.close();
            try {
                this.listenThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.throwing("close", e);
            }
        }
        LOGGER.exiting("close");
    }
}

