/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.ThreadManager;
import nor.util.log.EasyLogger;

class ListenWorker
implements Runnable,
Closeable {
    private final String hostname;
    private final int port;
    private final ThreadManager tmanager;
    private Selector selector;
    private boolean running = true;
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ListenWorker.class);

    public ListenWorker(String hostname, int port, HttpRequestHandler handler, int minThreads, int queueSize, int timeout) {
        this.hostname = hostname;
        this.port = port;
        this.tmanager = new ThreadManager(handler, minThreads, queueSize, timeout);
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            this.selector = Selector.open();
            this.createServerChannel(this.selector);
            LOGGER.info("Starts listening");
            while (this.running) {
                int nc = this.selector.selectNow();
                LOGGER.finest("Begins a selection (" + nc + " selected keys, " + this.selector.keys().size() + " registrated keys)");
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    try {
                        try {
                            if (key.isAcceptable()) {
                                ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                                SocketChannel socket = serverChannel.accept();
                                if (socket != null) {
                                    LOGGER.finest("Receive an accsptable key from " + socket.socket());
                                    Connection con = new Connection(socket, this.selector);
                                    this.tmanager.offer(con);
                                } else {
                                    LOGGER.finest("Receive an accsptable but null key");
                                    key.cancel();
                                }
                            } else {
                                Object o = key.attachment();
                                if (o != null) {
                                    assert (o instanceof Connection);
                                    Connection con = (Connection)o;
                                    int ret = -1;
                                    if (key.isReadable()) {
                                        LOGGER.finest("Receives a readable key from the " + con.toString());
                                        ret = con.loadFromChannel();
                                    } else if (key.isWritable() && key.isValid()) {
                                        LOGGER.finest("Receives a writable key from the " + con.toString());
                                        ret = con.storeToChannel();
                                    }
                                    if (ret == -1) {
                                        con.close();
                                    }
                                } else {
                                    LOGGER.finest("Receives a no associated key");
                                    key.cancel();
                                }
                            }
                        }
                        catch (CancelledKeyException e) {
                            LOGGER.throwing("run", e);
                            Object o = key.attachment();
                            if (o instanceof Connection) {
                                ((Connection)o).close();
                            }
                            iter.remove();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        iter.remove();
                        throw throwable;
                    }
                    iter.remove();
                }
                this.selector.selectedKeys().clear();
                LOGGER.finest("Ends the selection");
            }
            this.selector.close();
            LOGGER.info("Ends listening");
        }
        catch (IOException e) {
            LOGGER.throwing("run", e);
            LOGGER.severe("ListenWorker is stopped by " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    private void createServerChannel(Selector selector) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress(this.hostname, this.port);
        serverChannel.socket().bind(addr);
        serverChannel.register(selector, 16);
        LOGGER.info("Bind socket to " + addr);
    }
}

