/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.ServiceWorker;

class ThreadManager
implements Closeable,
Queue<Connection> {
    private final int minThreads;
    private final int queueSize;
    private final int timeout;
    private final Queue<Connection> queue = new LinkedList<Connection>();
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private final HttpRequestHandler handler;

    public ThreadManager(HttpRequestHandler handler, int minThreads, int queueSize, int timeout) {
        this.handler = handler;
        this.minThreads = minThreads;
        this.queueSize = queueSize;
        this.timeout = timeout;
    }

    @Override
    public synchronized boolean offer(Connection e) {
        boolean ret = this.queue.offer(e);
        if (ret) {
            if (ServiceWorker.nThreads() < this.minThreads || this.size() > this.queueSize) {
                this.pool.execute(ServiceWorker.create(this, this.handler));
            }
            this.notify();
        }
        return ret;
    }

    @Override
    public synchronized Connection poll() {
        try {
            if (this.isEmpty()) {
                this.wait(this.timeout);
            }
            return this.queue.poll();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void close() {
        this.pool.shutdown();
    }

    @Override
    public boolean add(Connection e) {
        return this.offer(e);
    }

    @Override
    public Connection remove() {
        Connection ret = this.poll();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Connection element() {
        return this.queue.element();
    }

    @Override
    public Connection peek() {
        return this.queue.peek();
    }

    @Override
    public boolean addAll(Collection<? extends Connection> c) {
        for (Connection connection : c) {
            this.add(connection);
        }
        return true;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean ret = this.queue.retainAll(c);
        this.notify();
        return ret;
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }
}

