/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.error.HttpException;
import nor.http.error.NotFoundException;
import nor.http.server.rest.Resource;

public class DirResource
extends Resource
implements Collection<Resource> {
    private final String name;
    private final List<Resource> children = Collections.synchronizedList(new ArrayList());
    private static final Logger LOGGER = Logger.getLogger(DirResource.class.getName());

    public DirResource(String name) {
        LOGGER.entering(DirResource.class.getName(), "<init>", name);
        assert (name != null);
        this.name = name;
        LOGGER.exiting(DirResource.class.getName(), "<init>");
    }

    @Override
    public String getName() {
        LOGGER.entering(DirResource.class.getName(), "getName");
        String ret = this.name;
        LOGGER.exiting(DirResource.class.getName(), "getName", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse toDelete(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(DirResource.class.getName(), "toDelete");
        HttpResponse ret = null;
        String name = path.substring(this.name.length() + 1);
        List<Resource> list = this.children;
        synchronized (list) {
            for (Resource r : this.children) {
                if (name.startsWith(r.getName()) && (ret = r.toDelete(name, request)) != null) break;
            }
        }
        if (ret == null) {
            throw new NotFoundException();
        }
        LOGGER.exiting(DirResource.class.getName(), "toDelete", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse toGet(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(DirResource.class.getName(), "toGet");
        HttpResponse ret = null;
        String name = path.substring(this.name.length() + 1);
        List<Resource> list = this.children;
        synchronized (list) {
            for (Resource r : this.children) {
                if (name.startsWith(r.getName()) && (ret = r.toGet(name, request)) != null) break;
            }
        }
        if (ret == null) {
            throw new NotFoundException();
        }
        LOGGER.exiting(DirResource.class.getName(), "toGet", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse toPost(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(DirResource.class.getName(), "toPost");
        HttpResponse ret = null;
        String name = path.substring(this.name.length() + 1);
        List<Resource> list = this.children;
        synchronized (list) {
            for (Resource r : this.children) {
                if (name.startsWith(r.getName()) && (ret = r.toPost(name, request)) != null) break;
            }
        }
        if (ret == null) {
            throw new NotFoundException();
        }
        LOGGER.exiting(DirResource.class.getName(), "toPost", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse toPut(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(DirResource.class.getName(), "toPut");
        HttpResponse ret = null;
        String name = path.substring(this.name.length() + 1);
        List<Resource> list = this.children;
        synchronized (list) {
            for (Resource r : this.children) {
                if (name.startsWith(r.getName()) && (ret = r.toPut(name, request)) != null) break;
            }
        }
        if (ret == null) {
            throw new NotFoundException();
        }
        LOGGER.exiting(DirResource.class.getName(), "toPut", ret);
        return ret;
    }

    public String toString() {
        return "DirResource : " + this.name;
    }

    @Override
    public boolean add(Resource r) {
        return this.children.add(r);
    }

    @Override
    public boolean remove(Object o) {
        return this.children.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends Resource> c) {
        return this.children.addAll(c);
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.children.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.children.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.children.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.children.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.children.retainAll(c);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.children.toArray(a);
    }
}

