/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.tserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;
import nor.http.HeaderName;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.HttpRequestHandler;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;

final class ServiceWorker
implements Runnable {
    private final Socket socket;
    private final HttpRequestHandler handler;
    private static final Logger LOGGER = Logger.getLogger(ServiceWorker.class.getName());
    private static final int DEFAULT_TIMEOUT = 6000;
    private static int Timeout = 6000;

    ServiceWorker(Socket socket, HttpRequestHandler handler) {
        LOGGER.entering(ServiceWorker.class.getName(), "<init>", new Object[]{socket, handler});
        assert (socket != null);
        assert (handler != null);
        this.socket = socket;
        this.handler = handler;
        LOGGER.exiting(ServiceWorker.class.getName(), "<init>");
    }

    @Override
    public void run() {
        block20: {
            block21: {
                LOGGER.entering(ServiceWorker.class.getName(), "run");
                LOGGER.fine("\u30bd\u30b1\u30c3\u30c8\u304c\u65b0\u3057\u3044\u8981\u6c42\u3092\u53d7\u7406");
                try {
                    this.socket.setKeepAlive(true);
                    this.socket.setSoTimeout(0);
                    BufferedInputStream input = new BufferedInputStream(new NoCloseInputStream(this.socket.getInputStream()), this.socket.getReceiveBufferSize());
                    BufferedOutputStream output = new BufferedOutputStream(new NoCloseOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
                    boolean keepAlive = true;
                    String prefix = "";
                    while (keepAlive) {
                        this.socket.setSoTimeout(Timeout);
                        HttpRequest request = HttpRequest.create(input, prefix);
                        if (request != null) {
                            this.socket.setSoTimeout(0);
                            Thread.currentThread().setName(request.getHeadLine());
                            keepAlive &= this.isKeepingAlive(request);
                            HttpResponse response = this.handler.doRequest(request);
                            keepAlive &= this.isKeepingAlive(response);
                            this.socket.setSoTimeout(5000);
                            response.output(output);
                            this.socket.setSoTimeout(0);
                            this.socket.getOutputStream().flush();
                            continue;
                        }
                        break;
                    }
                }
                catch (SocketTimeoutException e) {
                    LOGGER.fine(e.getLocalizedMessage());
                    if (!this.socket.isClosed()) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException e2) {
                            LOGGER.warning("\u30bd\u30b1\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc");
                        }
                    }
                    Thread.currentThread().setName("Sleep");
                    break block20;
                }
                catch (IOException e) {
                    try {
                        LOGGER.warning(e.getLocalizedMessage());
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (!this.socket.isClosed()) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException e3) {
                                LOGGER.warning("\u30bd\u30b1\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc");
                            }
                        }
                        Thread.currentThread().setName("Sleep");
                    }
                }
                if (this.socket.isClosed()) break block21;
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOGGER.warning("\u30bd\u30b1\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc");
                }
            }
            Thread.currentThread().setName("Sleep");
        }
        LOGGER.fine("\u8981\u6c42\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        LOGGER.exiting(ServiceWorker.class.getName(), "run");
    }

    private boolean isKeepingAlive(HttpRequest request) {
        return !request.getHeader().containsValue(HeaderName.Connection, "close");
    }

    private boolean isKeepingAlive(HttpResponse response) {
        return !response.getHeader().containsValue(HeaderName.Connection, "close");
    }

    static void setTimeout(int timeout) {
        Timeout = timeout;
    }
}

