/*
 * Decompiled with CFR 0.152.
 */
package nor.util.log;

import java.util.logging.LogManager;
import java.util.logging.Logger;

public class EasyLogger
extends Logger {
    private final String classname;

    private EasyLogger(String classname) {
        super(classname, null);
        this.classname = classname;
    }

    public static <T> EasyLogger getLogger(Class<T> type) {
        String classname = type.getName();
        LogManager m = LogManager.getLogManager();
        Logger log = m.getLogger(classname);
        if (log == null || !(log instanceof EasyLogger)) {
            EasyLogger n = new EasyLogger(classname);
            m.addLogger(n);
            return n;
        }
        return (EasyLogger)log;
    }

    public <T> void entering(String method, T ... params) {
        super.entering(this.classname, method, params);
    }

    public void exiting(String method) {
        super.exiting(this.classname, method);
    }

    public <T> void exiting(String method, T param) {
        super.exiting(this.classname, method, param);
    }

    public void finest(Object msg) {
        if (msg == null) {
            super.finest("null");
        } else {
            super.finest(msg.toString());
        }
    }

    public void warning(Object msg) {
        if (msg == null) {
            super.warning("null");
        } else {
            super.warning(msg.toString());
        }
    }

    public void severe(Object msg) {
        if (msg == null) {
            super.severe("null");
        } else {
            super.severe(msg.toString());
        }
    }

    public void throwing(String method, Throwable e) {
        super.throwing(this.classname, method, e);
    }
}

