/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import nor.core.plugin.Plugin;
import nor.util.log.Logger;

class Config {
    private final Properties prop;
    private final File configFile;
    private static final Logger LOGGER = Logger.getLogger(Config.class);

    Config(File configFile) {
        LOGGER.entering(Config.class.getName(), "<init>", configFile);
        assert (configFile != null);
        this.configFile = configFile;
        this.prop = new Properties();
        if (configFile.exists()) {
            try {
                this.prop.load(new FileInputStream(configFile));
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
                this.loadDefault();
            }
        } else {
            this.loadDefault();
        }
        LOGGER.exiting(Config.class.getName(), "<init>");
    }

    public String getListenAddress() {
        LOGGER.entering("getListenAddress", new Object[0]);
        String ret = this.prop.getProperty("nor.address");
        LOGGER.exiting("getListenAddress", ret);
        return ret;
    }

    public int getListenPort() {
        LOGGER.entering("getListenPort", new Object[0]);
        int ret = Integer.valueOf(this.prop.getProperty("nor.port"));
        LOGGER.exiting("getListenPort", ret);
        return ret;
    }

    public boolean isEnable(Plugin plugin) {
        LOGGER.entering(Config.class.getName(), "isEnabel", plugin);
        assert (plugin != null);
        boolean ret = Boolean.parseBoolean(this.prop.getProperty(String.format("%s.enable", plugin.getClass().getName()), "true"));
        LOGGER.exiting(Config.class.getName(), "isEnable", ret);
        return ret;
    }

    void store() throws FileNotFoundException, IOException {
        LOGGER.entering("save", new Object[0]);
        this.prop.store(new FileOutputStream(this.configFile), "");
        LOGGER.exiting("save");
    }

    void setEnable(Plugin plugin, boolean enable) {
        LOGGER.entering("setEnable", plugin, enable);
        assert (plugin != null);
        this.prop.setProperty(String.format("%s.enable", plugin.getClass().getName()), Boolean.toString(enable));
        LOGGER.exiting("setEnable");
    }

    void setListenAddress(String address) {
        LOGGER.entering("setListenAddress", address);
        assert (address != null);
        this.prop.setProperty("nor.address", address);
        LOGGER.exiting("setListenAddress");
    }

    void setListenPort(int port) {
        LOGGER.entering("setListenPort", port);
        assert (port > 0);
        this.prop.setProperty("nor.port", Integer.toString(port));
        LOGGER.exiting("setListenPort");
    }

    String get(String key) {
        return this.prop.getProperty(key);
    }

    private void loadDefault() {
        LOGGER.entering("loadDefault", new Object[0]);
        this.setListenAddress("127.0.0.1");
        this.setListenPort(8080);
        try {
            this.store();
        }
        catch (FileNotFoundException e) {
            LOGGER.warning(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
        LOGGER.exiting("loadDefault");
    }

    private static final class Key {
        public static final String LISTEN_ADDRESS = "nor.address";
        public static final String LISTEN_PORT = "nor.port";

        private Key() {
        }
    }

    private static final class Template {
        public static final String PLUGIN_ENABEL = "%s.enable";

        private Template() {
        }
    }
}

