/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.util.log.Logger;

class Context {
    private final String mac;
    private static final Logger LOGGER = Logger.getLogger(Context.class);
    private static final Pattern GATEWAY_IP = Pattern.compile("Gateway.*((\\d{1,3}\\.){3}\\d{1,3})");

    public Context() {
        block8: {
            LOGGER.entering("<init>", new Object[0]);
            String gatewayMAC = null;
            try {
                try {
                    String buf;
                    String buf2;
                    String gatwayIP = null;
                    Process ipconfig = new ProcessBuilder("ipconfig").start();
                    BufferedReader r1 = new BufferedReader(new InputStreamReader(ipconfig.getInputStream()));
                    boolean flag = false;
                    while ((buf2 = r1.readLine()) != null) {
                        Matcher m;
                        if (buf2.contains("Ethernet")) {
                            flag = true;
                            continue;
                        }
                        if (!flag || !(m = GATEWAY_IP.matcher(buf2)).find()) continue;
                        gatwayIP = m.group(1);
                        break;
                    }
                    r1.close();
                    ipconfig.destroy();
                    Pattern MAC = Pattern.compile(String.valueOf(gatwayIP) + ".*(([0-9a-fA-F]{2}-){5}[0-9a-fA-F]{2})");
                    Process arp = new ProcessBuilder("arp", "-a").start();
                    BufferedReader r2 = new BufferedReader(new InputStreamReader(arp.getInputStream()));
                    while ((buf = r2.readLine()) != null) {
                        Matcher m = MAC.matcher(buf);
                        if (!m.find()) continue;
                        gatewayMAC = m.group(1);
                        break;
                    }
                    r2.close();
                    arp.destroy();
                }
                catch (IOException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                    LOGGER.info("Gateway MAC-Address: " + gatewayMAC);
                    this.mac = gatewayMAC;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                LOGGER.info("Gateway MAC-Address: " + gatewayMAC);
                this.mac = gatewayMAC;
                throw throwable;
            }
            LOGGER.info("Gateway MAC-Address: " + gatewayMAC);
            this.mac = gatewayMAC;
        }
        LOGGER.exiting("<init>");
    }

    public String getMAC() {
        LOGGER.entering("getMAC", new Object[0]);
        String ret = this.mac;
        LOGGER.exiting("getMAC", ret);
        return ret;
    }
}

