/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.io.ChunkedInputStream;
import nor.http.io.ChunkedOutputStream;
import nor.util.io.LimitedInputStream;
import nor.util.io.LimitedOutputStream;
import nor.util.io.Stream;
import nor.util.log.Logger;

public class HttpBody
implements Closeable {
    private InputStream in;
    private static final Logger LOGGER = Logger.getLogger(HttpBody.class);

    HttpBody(InputStream in) {
        this.in = in;
    }

    HttpBody(InputStream in, HttpHeader header) throws IOException {
        this(in);
        if (header.containsKey(HeaderName.TransferEncoding)) {
            this.in = new ChunkedInputStream(this.in);
        } else if (header.containsKey(HeaderName.ContentLength)) {
            String length = header.get(HeaderName.ContentLength);
            this.in = new LimitedInputStream(this.in, Integer.valueOf(length));
        }
        if (header.containsKey(HeaderName.ContentEncoding)) {
            String encode = header.get(HeaderName.ContentEncoding);
            if ("gzip".equalsIgnoreCase(encode)) {
                this.in = new GZIPInputStream(this.in);
            } else if ("deflate".equalsIgnoreCase(encode)) {
                this.in = new DeflaterInputStream(this.in);
            }
        }
    }

    public void output(OutputStream out) throws IOException {
        if (this.in != null) {
            Stream.copy(this.in, out);
        }
        out.flush();
    }

    public void output(OutputStream out, HttpHeader header) throws IOException {
        OutputStream cout = out;
        if (header.containsKey(HeaderName.ContentLength)) {
            String length = header.get(HeaderName.ContentLength).split(",")[0];
            cout = new LimitedOutputStream(cout, Integer.parseInt(length));
        } else if ("chunked".equalsIgnoreCase(header.get(HeaderName.TransferEncoding))) {
            cout = new ChunkedOutputStream(cout);
        }
        if (header.containsKey(HeaderName.ContentEncoding)) {
            String encode = header.get(HeaderName.ContentEncoding);
            if ("gzip".equalsIgnoreCase(encode)) {
                cout = new GZIPOutputStream(cout, Stream.DefaultBufferSize);
            } else if ("deflate".equalsIgnoreCase(encode)) {
                cout = new DeflaterOutputStream(cout);
            }
        }
        this.output(cout);
        cout.close();
    }

    public InputStream getStream() {
        LOGGER.entering("getStream", new Object[0]);
        LOGGER.exiting("getStream", this.in);
        return this.in;
    }

    public void setStream(InputStream in) {
        LOGGER.entering("setStream", in);
        this.in = in;
        LOGGER.exiting("setStream");
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

