/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.http.HeaderName;
import nor.util.log.Logger;

public class HttpHeader {
    private static final Pattern HEADER = Pattern.compile("^([^:]+):\\s*(.*)$");
    private final Map<String, String> elements = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(HttpHeader.class);

    HttpHeader() {
        LOGGER.entering("<init>", new Object[0]);
        LOGGER.exiting("<init>");
    }

    HttpHeader(BufferedReader reader) throws IOException {
        LOGGER.entering("<init>", reader);
        assert (reader != null);
        String line = reader.readLine();
        while (line != null) {
            String key;
            Matcher m = HEADER.matcher(line);
            if (m.matches() && (key = m.group(1).toLowerCase()) != null) {
                String value = m.group(2);
                this.add(key, value);
            }
            line = reader.readLine();
        }
        LOGGER.exiting("<init>");
    }

    HttpHeader(Map<String, String> elements) {
        LOGGER.entering("<init>", elements);
        assert (elements != null);
        for (String key : elements.keySet()) {
            if (key == null) continue;
            this.add(key.toLowerCase(), elements.get(key));
        }
        LOGGER.exiting("<init>");
    }

    public void set(String key, String value) {
        LOGGER.entering("set", key, value);
        assert (key != null);
        assert (value != null);
        String skey = key.toLowerCase();
        if (this.elements.containsKey(skey)) {
            this.elements.remove(skey);
        }
        this.elements.put(skey, value);
        LOGGER.fine("Header set: " + skey + ": " + value);
        LOGGER.exiting("set");
    }

    public void add(String key, String value) {
        String skey = key.toLowerCase();
        if (this.elements.containsKey(skey)) {
            if (HeaderName.SetCookie.equals(skey)) {
                String nvalue = String.format("%s\n  %s", this.elements.get(skey), value);
                this.elements.remove(skey);
                this.elements.put(skey, nvalue);
            } else {
                String nvalue = String.format("%s, %s", this.elements.get(skey), value);
                this.elements.remove(skey);
                this.elements.put(skey, nvalue);
            }
        } else {
            this.elements.put(skey, value);
        }
        LOGGER.fine("Header add: " + skey + ": " + value);
    }

    public void remove(String key) {
        LOGGER.entering("remove", key);
        assert (key != null);
        String skey = key.toLowerCase();
        this.elements.remove(skey);
        LOGGER.exiting("remove");
    }

    public void clear() {
        LOGGER.entering("clear", new Object[0]);
        this.elements.clear();
        LOGGER.exiting("clear");
    }

    public String get(String key) {
        LOGGER.entering("getValue", key);
        assert (key != null);
        String skey = key.toLowerCase();
        String ret = this.elements.get(skey);
        LOGGER.exiting("getValues", ret);
        return ret;
    }

    public boolean containsKey(String key) {
        LOGGER.entering("containsKey", key);
        assert (key != null);
        String skey = key.toLowerCase();
        boolean ret = this.elements.containsKey(skey);
        LOGGER.exiting("containsKey", ret);
        return ret;
    }

    public boolean containsValue(String key, String value) {
        String skey = key.toLowerCase();
        String v = this.get(skey);
        if (v != null) {
            String[] stringArray = v.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(value)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Set<String> keySet() {
        LOGGER.entering("keySet", new Object[0]);
        Set<String> ret = this.elements.keySet();
        LOGGER.exiting("keySet", ret);
        return ret;
    }

    public int getKeySize() {
        LOGGER.entering("getKeySize", new Object[0]);
        int ret = this.elements.size();
        LOGGER.exiting("getKeySize", ret);
        return ret;
    }

    public void writeHeader(BufferedWriter writer) throws IOException {
        LOGGER.entering("writeHeader", writer);
        assert (writer != null);
        for (String key : this.elements.keySet()) {
            if (HeaderName.SetCookie.equals(key)) {
                String[] stringArray = this.get(key).split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    writer.append(key);
                    writer.append(": ");
                    writer.append(v.trim());
                    writer.newLine();
                    LOGGER.fine("Header write: " + key + ": " + v.trim());
                    ++n2;
                }
                continue;
            }
            writer.append(key);
            writer.append(": ");
            writer.append(this.get(key));
            writer.newLine();
            LOGGER.fine("Header write: " + key + ": " + this.get(key));
        }
        writer.flush();
        LOGGER.exiting("writeHeader");
    }

    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        StringWriter buffer = new StringWriter();
        String ret = "";
        try {
            this.writeHeader(new BufferedWriter(buffer));
            ret = buffer.toString();
        }
        catch (IOException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
        LOGGER.exiting("toString", ret);
        return ret;
    }

    public void set(HeaderName key, String value) {
        this.set(key.toString(), value);
    }

    public void add(HeaderName key, String value) {
        this.add(key.toString(), value);
    }

    public void remove(HeaderName key) {
        this.remove(key.toString());
    }

    public String get(HeaderName key) {
        return this.get(key.toString());
    }

    public boolean containsKey(HeaderName key) {
        return this.containsKey(key.toString());
    }

    public boolean containsValue(HeaderName key, String value) {
        return this.containsValue(key.toString(), value);
    }
}

