/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import nor.http.HttpBody;
import nor.http.HttpHeader;
import nor.util.log.Logger;

public abstract class HttpMessage {
    private static final Logger LOGGER = Logger.getLogger(HttpMessage.class);

    public void output(OutputStream output) throws IOException {
        LOGGER.entering("writeMessage", output);
        assert (output != null);
        HttpHeader header = this.getHeader();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.append(this.getHeadLine());
        writer.append('\r');
        writer.append('\n');
        writer.flush();
        header.writeHeader(writer);
        writer.append('\r');
        writer.append('\n');
        writer.flush();
        writer.close();
        this.getBody().output(output, this.getHeader());
        this.getBody().close();
        output.close();
        LOGGER.exiting("writeMessage");
    }

    public abstract String getVersion();

    public abstract String getPath();

    public abstract HttpHeader getHeader();

    public abstract HttpBody getBody();

    public abstract String getHeadLine();

    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        StringBuilder ret = new StringBuilder();
        ret.append(this.getHeadLine());
        ret.append("\n");
        ret.append(this.getHeader());
        ret.append("\n");
        LOGGER.exiting("toString", ret.toString());
        return ret.toString();
    }
}

