/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import nor.http.server.nserver.SocketChannelInputStream;
import nor.http.server.nserver.SocketChannelOutputStream;
import nor.util.log.Logger;

class Connection
implements Closeable {
    private final SelectionKey key;
    private final SocketChannelInputStream in;
    private final SocketChannelOutputStream out;
    private final SocketChannel schannel;
    private static final Logger LOGGER = Logger.getLogger(Connection.class);

    public Connection(SocketChannel schannel, Selector selector) throws IOException {
        this.schannel = schannel;
        this.schannel.configureBlocking(false);
        this.key = this.schannel.register(selector, 0);
        this.key.attach(this);
        this.in = new SocketChannelInputStream(this.key);
        this.out = new SocketChannelOutputStream(this.key);
    }

    public boolean handle() {
        int ret = -1;
        if (this.key.isReadable()) {
            LOGGER.finest("Receives a readable key from the " + this.toString());
            ret = this.in.loadFromChannel(this.schannel);
        } else if (this.key.isWritable() && this.key.isValid()) {
            LOGGER.finest("Receives a writable key from the " + this.toString());
            ret = this.out.storeToChannel(this.schannel);
        }
        return ret != -1;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
            this.out.close();
        }
        finally {
            Selector selector = this.key.selector();
            this.key.attach(null);
            this.key.channel().close();
            this.key.cancel();
            selector.wakeup();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public String toString() {
        return String.format("Connection from the %s", this.schannel.socket());
    }
}

