/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.nserver.ListenWorker;
import nor.http.server.nserver.ThreadManager;
import nor.util.log.Logger;

public class HttpNServer
implements HttpServer {
    public static final String VERSION = "1.1";
    private final HttpRequestHandler handler;
    private ListenWorker listener;
    private Thread listenThread;
    private ThreadManager workerThreadManager;
    private static final Logger LOGGER = Logger.getLogger(HttpNServer.class);
    private static final String KeyTemplate = "%s.%s";
    private static final String MinThreadsKey = "MinimusThreads";
    private static final String TimeoutKey = "Timeout";

    public HttpNServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, (Object)port);
        if (this.listener != null || this.workerThreadManager != null) {
            this.close();
        }
        String classname = this.getClass().getName();
        int mThreads = Integer.valueOf(System.getProperty(String.format(KeyTemplate, classname, MinThreadsKey)));
        int timeout = Integer.valueOf(System.getProperty(String.format(KeyTemplate, classname, TimeoutKey)));
        this.workerThreadManager = new ThreadManager(this.handler, mThreads, timeout);
        this.listener = new ListenWorker(hostname, port, this.workerThreadManager);
        this.listenThread = new Thread(this.listener);
        this.listenThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        if (this.listener != null) {
            this.listener.close();
            try {
                this.listenThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.throwing("close", e);
            }
            this.listener = null;
        }
        if (this.workerThreadManager != null) {
            this.workerThreadManager.close();
            this.workerThreadManager = null;
        }
        LOGGER.exiting("close");
    }
}

