/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.ThreadManager;
import nor.util.log.Logger;

class ListenWorker
implements Runnable,
Closeable {
    private final String hostname;
    private final int port;
    private final ThreadManager tmanager;
    private final Selector selector;
    private boolean running = true;
    private static final Logger LOGGER = Logger.getLogger(ListenWorker.class);

    public ListenWorker(String hostname, int port, ThreadManager manager) throws IOException {
        this.hostname = hostname;
        this.port = port;
        this.tmanager = manager;
        this.selector = Selector.open();
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            this.createServerChannel(this.selector);
            LOGGER.info("Starts listening");
            while (this.running) {
                int nc = this.selector.selectNow();
                LOGGER.finest("Begins a selection (%d selected keys, %d registrated keys)", nc, this.selector.keys().size());
                for (SelectionKey key : this.selector.selectedKeys()) {
                    try {
                        if (key.isAcceptable()) {
                            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                            SocketChannel socket = serverChannel.accept();
                            if (socket != null) {
                                LOGGER.finest("Receive an accsptable key from %s", socket.socket());
                                Connection con = new Connection(socket, this.selector);
                                this.tmanager.offer(con);
                                continue;
                            }
                            LOGGER.finest("Receive an accsptable but null key");
                            key.cancel();
                            continue;
                        }
                        Object o = key.attachment();
                        if (o != null) {
                            assert (o instanceof Connection);
                            Connection con = (Connection)o;
                            con.handle();
                            continue;
                        }
                        LOGGER.finest("Receives a no associated key");
                        key.cancel();
                    }
                    catch (CancelledKeyException e) {
                        LOGGER.info(e.getMessage());
                        Object o = key.attachment();
                        if (!(o instanceof Connection)) continue;
                        ((Connection)o).close();
                    }
                }
                this.selector.selectedKeys().clear();
                LOGGER.finest("Ends the selection");
            }
            LOGGER.info("Ends listening");
        }
        catch (IOException e) {
            LOGGER.severe("ListenWorker is stopped by " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        this.selector.close();
    }

    private void createServerChannel(Selector selector) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress(this.hostname, this.port);
        serverChannel.socket().bind(addr);
        serverChannel.register(selector, 16);
        LOGGER.info("Bind socket to %s", addr);
    }
}

