/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.NoExceptionOutputStreamFilter;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;
import nor.util.log.Logger;

class ServiceWorker
implements Runnable,
Closeable {
    private boolean running = true;
    private final Queue<Connection> queue;
    private final HttpRequestHandler handler;
    private final List<EndEventListener> listeners = new ArrayList<EndEventListener>();
    private static final Logger LOGGER = Logger.getLogger(ServiceWorker.class);

    public ServiceWorker(Queue<Connection> queue, HttpRequestHandler handler) {
        this.queue = queue;
        this.handler = handler;
    }

    public void addListener(EndEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EndEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void run() {
        LOGGER.entering("run", new Object[0]);
        while (this.running) {
            Connection con = this.queue.poll();
            if (con != null) {
                LOGGER.finest("%s begins to handle the connection; %s", Thread.currentThread().getName(), con);
                BufferedInputStream input = new BufferedInputStream(new NoCloseInputStream(con.getInputStream()));
                BufferedOutputStream output = new BufferedOutputStream(new NoExceptionOutputStreamFilter(new NoCloseOutputStream(con.getOutputStream())));
                boolean keepAlive = true;
                while (keepAlive && this.running) {
                    String prefix = "";
                    HttpRequest request = HttpRequest.create(input, prefix);
                    if (request == null) {
                        LOGGER.finest("%s receives a null request", Thread.currentThread().getName());
                        keepAlive = false;
                        continue;
                    }
                    LOGGER.finest("%s receives the %s", Thread.currentThread().getName(), request);
                    keepAlive &= this.isKeepingAlive(request);
                    HttpResponse response = this.handler.doRequest(request);
                    keepAlive &= this.isKeepingAlive(response);
                    try {
                        HttpHeader header = response.getHeader();
                        if (header.containsKey(HeaderName.ContentLength)) {
                            LOGGER.info("%s > %s (%s bytes)", request.getHeadLine(), response.getHeadLine(), header.get(HeaderName.ContentLength));
                        } else {
                            LOGGER.info("%s > %s (unknown length)", request.getHeadLine(), response.getHeadLine());
                        }
                        response.output(output);
                        ((OutputStream)output).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println(response.getHeadLine());
                        System.out.println(response.getHeader().toString());
                        keepAlive = false;
                    }
                }
                LOGGER.finest("%s finishes to handle and closes the connection; %s", Thread.currentThread().getName(), con);
                try {
                    con.close();
                }
                catch (IOException e) {
                    LOGGER.warning(e.getMessage());
                }
                continue;
            }
            this.running = false;
        }
        for (EndEventListener listener : this.listeners) {
            listener.update(this);
        }
        LOGGER.exiting("run");
    }

    @Override
    public void close() {
        this.running = false;
    }

    private boolean isKeepingAlive(HttpMessage msg) {
        return !msg.getHeader().containsValue(HeaderName.Connection, "close");
    }

    public static interface EndEventListener {
        public void update(ServiceWorker var1);
    }
}

