/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import nor.util.log.Logger;

class SocketChannelInputStream
extends InputStream {
    private SelectionKey key;
    private final ByteBuffer buffer;
    private static final Logger LOGGER = Logger.getLogger(SocketChannelInputStream.class);
    private static final int BufferSize;
    private static final int Timeout;

    static {
        String classname = SocketChannelInputStream.class.getName();
        BufferSize = Integer.valueOf(System.getProperty(String.format("%s.BufferSize", classname)));
        Timeout = Integer.valueOf(System.getProperty(String.format("%s.Timeout", classname)));
    }

    public SocketChannelInputStream(SelectionKey key) {
        this.key = key;
        this.buffer = ByteBuffer.allocate(BufferSize);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.key == null) {
            return -1;
        }
        if (this.available() == 0) {
            this.load();
            if (this.available() == 0) {
                this.close();
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available;
        if (this.key == null) {
            return -1;
        }
        if (this.available() == 0) {
            this.load();
            if (this.available() == 0) {
                this.close();
                return -1;
            }
        }
        if (len > (available = this.available())) {
            this.buffer.get(b, off, available);
            return available;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.buffer.limit() - this.buffer.position();
    }

    @Override
    public void close() {
        if (this.key != null) {
            if (this.key.isValid()) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
            }
            this.key = null;
        }
    }

    public synchronized int loadFromChannel(ReadableByteChannel channel) {
        int ret;
        block6: {
            LOGGER.entering("loadFromChannel", channel);
            ret = -1;
            try {
                try {
                    if (this.key != null) {
                        this.buffer.clear();
                        ret = channel.read(this.buffer);
                        this.buffer.flip();
                        this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
                    }
                }
                catch (IOException e) {
                    LOGGER.warning(e.getMessage());
                    this.close();
                    this.notify();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.notify();
                throw throwable;
            }
            this.notify();
        }
        LOGGER.exiting("loadFromChannel", ret);
        return ret;
    }

    private synchronized void load() throws IOException {
        LOGGER.entering("load", new Object[0]);
        if (this.key != null) {
            try {
                this.key.interestOps(this.key.interestOps() | 1);
                this.key.selector().wakeup();
                this.wait(Timeout);
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
                LOGGER.throwing("load", e);
                throw new IOException(e);
            }
            catch (CancelledKeyException e) {
                this.close();
                LOGGER.throwing("load", e);
                throw new IOException(e);
            }
        }
        LOGGER.exiting("load");
    }
}

