/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import nor.http.server.nserver.SocketChannelInputStream;
import nor.util.log.Logger;

class SocketChannelOutputStream
extends OutputStream {
    private SelectionKey key;
    private final ByteBuffer buffer;
    private static final Logger LOGGER = Logger.getLogger(SocketChannelOutputStream.class);
    private static final int BufferSize;
    private static final int Timeout;

    static {
        String classname = SocketChannelInputStream.class.getName();
        BufferSize = Integer.valueOf(System.getProperty(String.format("%s.BufferSize", classname)));
        Timeout = Integer.valueOf(System.getProperty(String.format("%s.Timeout", classname)));
    }

    public SocketChannelOutputStream(SelectionKey key) {
        this.key = key;
        this.buffer = ByteBuffer.allocate(BufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.key != null) {
            if (this.available() == 0) {
                this.flush();
                if (this.available() == 0) {
                    this.key = null;
                    return;
                }
            }
            try {
                this.buffer.put((byte)b);
            }
            catch (BufferOverflowException e) {
                LOGGER.severe(String.valueOf(e.getMessage()) + " pos " + this.buffer.position() + ", lim " + this.buffer.limit() + ", cap " + this.buffer.capacity());
                this.key = null;
            }
        } else {
            IOException e = new IOException("Stream is already closed.");
            LOGGER.throwing("write", e);
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.key != null) {
            while (len != 0) {
                int size;
                if (this.available() == 0) {
                    this.flush();
                    if (this.available() == 0) {
                        this.key = null;
                        return;
                    }
                }
                if (len > (size = this.available())) {
                    this.buffer.put(b, off, size);
                    off += size;
                    len -= size;
                    continue;
                }
                this.buffer.put(b, off, len);
                off += len;
                len -= len;
            }
        } else {
            IOException e = new IOException("Stream is already closed.");
            LOGGER.throwing("write", e);
            throw e;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.key != null) {
            try {
                this.key.interestOps(this.key.interestOps() | 4);
                this.key.selector().wakeup();
                this.wait(Timeout);
            }
            catch (InterruptedException e) {
                this.key = null;
                Thread.currentThread().interrupt();
                LOGGER.throwing("flush", e);
                throw new IOException(e);
            }
            catch (CancelledKeyException e) {
                this.key = null;
                LOGGER.throwing("flush", e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.key != null) {
            if (this.key.isValid()) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
            this.key = null;
        }
    }

    public synchronized int storeToChannel(WritableByteChannel channel) {
        int ret = -1;
        if (this.key != null) {
            try {
                try {
                    this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
                    this.buffer.flip();
                    ret = channel.write(this.buffer);
                    this.buffer.clear();
                }
                catch (IOException e) {
                    LOGGER.info(e.getMessage());
                    this.key = null;
                    this.notify();
                }
            }
            finally {
                this.notify();
            }
        }
        return ret;
    }

    private int available() {
        return this.buffer.limit() - this.buffer.position();
    }
}

