/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.ServiceWorker;
import nor.util.log.Logger;

class ThreadManager
implements Closeable,
Queue<Connection>,
ServiceWorker.EndEventListener {
    private int waiting = 0;
    private boolean running = true;
    private final int minThreads;
    private final int timeout;
    private final HttpRequestHandler handler;
    private final Queue<Connection> queue = new LinkedList<Connection>();
    private final ExecutorService pool;
    private final Set<ServiceWorker> workers = new HashSet<ServiceWorker>();
    private static final Logger LOGGER = Logger.getLogger(ThreadManager.class);

    public ThreadManager(HttpRequestHandler handler, int minThreads, int timeout) {
        this.pool = Executors.newCachedThreadPool();
        this.handler = handler;
        this.minThreads = minThreads;
        this.timeout = timeout;
    }

    @Override
    public synchronized boolean offer(Connection e) {
        boolean ret = this.queue.offer(e);
        if (ret) {
            if (this.workers.size() < this.minThreads || this.waiting == 0) {
                LOGGER.fine("Create a new worker thread.");
                ServiceWorker w = new ServiceWorker(this, this.handler);
                this.workers.add(w);
                this.pool.execute(w);
            }
            LOGGER.fine("Offer a new connection and send notify message.");
            this.notify();
        }
        return ret;
    }

    @Override
    public synchronized Connection poll() {
        Connection ret = null;
        if (this.running) {
            try {
                LOGGER.finer("Waiting = %d, working = %d, connection = %d", this.waiting, this.workers.size(), this.size());
                while (this.isEmpty() && this.waiting <= this.minThreads) {
                    LOGGER.finest("Be going to wait.");
                    ++this.waiting;
                    this.wait(this.timeout);
                    --this.waiting;
                    LOGGER.finest("Wake up.");
                }
                LOGGER.finer("Waiting = %d, working = %d, connection = %d", this.waiting, this.workers.size(), this.size());
                ret = this.queue.poll();
            }
            catch (InterruptedException e) {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public void close() {
        this.running = false;
        this.pool.shutdownNow();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.warning("Thread pool did not terminate.");
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean add(Connection e) {
        return this.offer(e);
    }

    @Override
    public Connection remove() {
        Connection ret = this.poll();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Connection element() {
        return this.queue.element();
    }

    @Override
    public Connection peek() {
        return this.queue.peek();
    }

    @Override
    public boolean addAll(Collection<? extends Connection> c) {
        for (Connection connection : c) {
            this.add(connection);
        }
        return true;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean ret = this.queue.retainAll(c);
        this.notify();
        return ret;
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public void update(ServiceWorker from) {
        this.workers.remove(from);
    }
}

