/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class Stream {
    public static final int DefaultBufferSize;

    static {
        String classname = Stream.class.getName();
        DefaultBufferSize = Integer.valueOf(System.getProperty(String.format("%s.DefaultBufferSize", classname)));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        Stream.copy(in, out, DefaultBufferSize);
    }

    public static void copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        ReadableByteChannel cin = Channels.newChannel(in);
        WritableByteChannel cout = Channels.newChannel(out);
        Stream.copy(cin, cout, bufSize);
    }

    public static void copy(ReadableByteChannel in, WritableByteChannel out, int bufSize) throws IOException {
        block2: {
            ByteBuffer buf = ByteBuffer.allocate(bufSize);
            long c = 0L;
            do {
                buf.clear();
                if (in.read(buf) < 0) break block2;
                buf.flip();
                int len = buf.limit() - buf.position();
                c += (long)len;
                while (len != 0) {
                    len -= out.write(buf);
                }
            } while (!Thread.interrupted());
            throw new IOException();
        }
    }
}

