/*
 * Decompiled with CFR 0.152.
 */
package nor.util.log;

import java.util.logging.LogManager;

public class Logger
extends java.util.logging.Logger {
    private final String classname;

    private Logger(String classname) {
        super(classname, null);
        this.classname = classname;
    }

    public static <T> Logger getLogger(Class<T> type) {
        String classname = type.getName();
        LogManager m = LogManager.getLogManager();
        java.util.logging.Logger log = m.getLogger(classname);
        if (log == null || !(log instanceof Logger)) {
            Logger n = new Logger(classname);
            m.addLogger(n);
            return n;
        }
        return (Logger)log;
    }

    public <T> void entering(String method, T ... params) {
        super.entering(this.classname, method, params);
    }

    public void exiting(String method) {
        super.exiting(this.classname, method);
    }

    public <T> void exiting(String method, T param) {
        super.exiting(this.classname, method, param);
    }

    public void finest(Object msg) {
        if (msg == null) {
            super.finest("null");
        } else {
            super.finest(msg.toString());
        }
    }

    public void warning(Object msg) {
        if (msg == null) {
            super.warning("null");
        } else {
            super.warning(msg.toString());
        }
    }

    public void severe(Object msg) {
        if (msg == null) {
            super.severe("null");
        } else {
            super.severe(msg.toString());
        }
    }

    public void throwing(String method, Throwable e) {
        super.throwing(this.classname, method, e);
    }

    public void info(String format, Object ... args) {
        super.info(String.format(format, args));
    }

    public void config(String format, Object ... args) {
        super.config(String.format(format, args));
    }

    public void fine(String format, Object ... args) {
        super.fine(String.format(format, args));
    }

    public void finer(String format, Object ... args) {
        super.finer(String.format(format, args));
    }

    public void finest(String format, Object ... args) {
        super.finest(String.format(format, args));
    }
}

