/*
 * Decompiled with CFR 0.152.
 */
package nor.core.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.util.Querable;

public abstract class Plugin
implements Closeable {
    protected final Properties properties = new Properties();
    protected Querable<Proxy> externalProxies;

    public void load(File conf) {
        if (conf.exists()) {
            try {
                this.properties.load(new FileInputStream(conf));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.init();
    }

    public void save(File conf) {
        try {
            this.properties.store(new FileOutputStream(conf), "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init() {
    }

    @Override
    public void close() {
    }

    public MessageHandler[] messageHandlers() {
        return null;
    }

    public RequestFilter[] requestFilters() {
        return null;
    }

    public ResponseFilter[] responseFilters() {
        return null;
    }

    public final void setExternalProxies(Querable<Proxy> externalProxies) {
        this.externalProxies = externalProxies;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        if (this.externalProxies != null) {
            return url.openConnection(this.externalProxies.query(url.toString()));
        }
        return url.openConnection();
    }
}

