/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.regex.Matcher;
import nor.http.HeaderName;
import nor.http.Http;
import nor.http.HttpBody;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.io.HeaderInputStream;
import nor.util.log.Logger;

public class HttpRequest
extends HttpMessage {
    private String method;
    private String path;
    private String version;
    private final HttpHeader header;
    private final HttpBody body;
    private static final Logger LOGGER = Logger.getLogger(HttpRequest.class);

    private HttpRequest(InputStream input, String prefix) throws IOException {
        String buf;
        LOGGER.entering("<init>", input, prefix);
        assert (input != null);
        BufferedReader in = new BufferedReader(new InputStreamReader(new HeaderInputStream(input)));
        while ((buf = in.readLine()) != null) {
            Matcher m = Http.RequestLinePattern.matcher(buf);
            if (!m.matches()) continue;
            this.method = m.group(1);
            this.path = String.valueOf(prefix) + m.group(2);
            this.version = m.group(3);
            break;
        }
        this.header = new HttpHeader(in);
        this.body = new HttpBody(input, this.header);
        LOGGER.exiting("<init>");
    }

    public String getMethodString() {
        LOGGER.entering("getMethodString", new Object[0]);
        String ret = this.method;
        LOGGER.exiting("getMethodString", ret);
        return ret;
    }

    public Method getMethod() {
        LOGGER.entering("getMethod", new Object[0]);
        Method ret = null;
        try {
            ret = Method.valueOf(this.method);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("getMethod", e.getMessage(), new Object[0]);
        }
        LOGGER.exiting("getMethod", (Object)ret);
        return ret;
    }

    public void setPath(String path) {
        LOGGER.entering("setPath", path);
        this.path = path;
        LOGGER.exiting("setPath");
    }

    @Override
    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        String ret = String.format("Request[method=%s, path=%s]\r\n%s", new Object[]{this.getMethod(), this.getPath(), this.header.toString()});
        LOGGER.exiting("toString", ret);
        return ret.toString();
    }

    public HttpResponse createResponse(InputStream input) throws HttpException {
        LOGGER.entering("createResponse", input);
        assert (input != null);
        HttpResponse ret = new HttpResponse(this, input);
        LOGGER.exiting("createResponse", ret);
        return ret;
    }

    public HttpResponse createResponse(Status status, InputStream body) {
        HttpResponse ret = new HttpResponse(this, status, body);
        return ret;
    }

    public HttpResponse createResponse(Status status) {
        return this.createResponse(status, "");
    }

    public HttpResponse createResponse(Status status, String body) {
        byte[] b = body.getBytes();
        HttpResponse ret = this.createResponse(status, new ByteArrayInputStream(b));
        HttpHeader header = ret.getHeader();
        header.set(HeaderName.ContentLength, Integer.toString(b.length));
        return ret;
    }

    @Override
    public String getVersion() {
        LOGGER.entering("getVersion", new Object[0]);
        String ret = this.version;
        LOGGER.exiting("getVersion", ret);
        return ret;
    }

    @Override
    public String getPath() {
        LOGGER.entering("getPath", new Object[0]);
        String ret = this.path;
        LOGGER.exiting("getPath", ret);
        return ret;
    }

    @Override
    public String getHeadLine() {
        LOGGER.entering("getHeadLine", new Object[0]);
        String ret = String.format(Http.RequestLineTemplate, this.method, this.path, this.version);
        LOGGER.exiting("getHeadLine", ret);
        return ret;
    }

    @Override
    public HttpHeader getHeader() {
        return this.header;
    }

    @Override
    public HttpBody getBody() {
        return this.body;
    }

    public static HttpRequest create(InputStream input, String prefix) {
        HttpRequest ret;
        block3: {
            try {
                ret = new HttpRequest(input, prefix);
                if (ret.getMethodString() != null) break block3;
                return null;
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "create", e);
                return null;
            }
        }
        return ret;
    }
}

