/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import nor.http.server.HttpRequestHandler;
import nor.http.server.nserver.Connection;
import nor.http.server.nserver.RequestHandleWorker;
import nor.util.log.Logger;

class ConnectionManager
implements Closeable,
Queue<Connection>,
RequestHandleWorker.ServiceEventListener {
    private int waiting = 0;
    private boolean running = true;
    private final int minThreads;
    private final int timeout;
    private final HttpRequestHandler handler;
    private final Queue<Connection> queue = new LinkedList<Connection>();
    private final ExecutorService pool;
    private final Set<RequestHandleWorker> workers = new HashSet<RequestHandleWorker>();
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class);

    public ConnectionManager(HttpRequestHandler handler, int minThreads, int timeout) {
        this.pool = Executors.newCachedThreadPool();
        this.handler = handler;
        this.minThreads = minThreads;
        this.timeout = timeout;
    }

    @Override
    public synchronized boolean offer(Connection e) {
        assert (e != null);
        if (e.closed()) {
            return false;
        }
        boolean ret = this.queue.offer(e);
        if (ret) {
            if (this.waiting == 0) {
                RequestHandleWorker w = new RequestHandleWorker(this, this.handler);
                this.workers.add(w);
                this.pool.execute(w);
                LOGGER.fine("offer", "Create a new worker thread (current: {0} threads).", this.workers.size());
            }
            LOGGER.finer("offer", "Offer a new connection and send notify message.", new Object[0]);
            this.notify();
        }
        return ret;
    }

    @Override
    public synchronized Connection poll() {
        Connection ret = null;
        if (this.running) {
            try {
                do {
                    LOGGER.finer("poll", "Waiting = {0}, working = {1}, connection = {2}", this.waiting, this.workers.size(), this.size());
                    while (this.isEmpty() && this.waiting <= this.minThreads) {
                        LOGGER.finest("poll", "Be going to wait.", new Object[0]);
                        ++this.waiting;
                        this.wait(this.timeout);
                        --this.waiting;
                        LOGGER.finest("poll", "Wake up.", new Object[0]);
                    }
                    LOGGER.finer("poll", "Waiting = {0}, working = {1}, connection = {2}", this.waiting, this.workers.size(), this.size());
                } while ((ret = this.queue.poll()) != null && ret.closed());
            }
            catch (InterruptedException e) {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public void close() {
        this.running = false;
        this.pool.shutdownNow();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.warning("close", "Thread pool did not terminate.", new Object[0]);
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onEnd(RequestHandleWorker from) {
        this.workers.remove(from);
        LOGGER.fine("update", "Remove a worker thread (current: {0} threads).", this.workers.size());
    }

    @Override
    public boolean add(Connection e) {
        return this.offer(e);
    }

    @Override
    public Connection remove() {
        Connection ret = this.poll();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Connection element() {
        return this.queue.element();
    }

    @Override
    public Connection peek() {
        return this.queue.peek();
    }

    @Override
    public boolean addAll(Collection<? extends Connection> c) {
        for (Connection connection : c) {
            this.add(connection);
        }
        return true;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean ret = this.queue.retainAll(c);
        this.notify();
        return ret;
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }
}

