/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import nor.http.server.nserver.NServer;
import nor.network.SelectionEventHandlerAdapter;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

class Delegator
implements Closeable {
    private final DelegationHandler h1;
    private final DelegationHandler h2;
    private static final Logger LOGGER = Logger.getLogger(Delegator.class);

    public Delegator(SelectionKey from, SelectableChannel to, SelectionWorker selector) throws IOException {
        ByteBuffer b1 = ByteBuffer.allocate(NServer.BufferSize);
        ByteBuffer b2 = ByteBuffer.allocate(NServer.BufferSize);
        this.h1 = new DelegationHandler(from, b1, b2);
        this.h2 = new DelegationHandler(to, b2, b1, selector);
        this.h1.setAnother(this.h2);
        this.h2.setAnother(this.h1);
    }

    @Override
    public void close() {
        this.h1.close();
        this.h2.close();
    }

    private final class DelegationHandler
    extends SelectionEventHandlerAdapter
    implements Closeable {
        private final SelectionKey key;
        private final ByteBuffer read;
        private final ByteBuffer write;
        private DelegationHandler another = null;
        private boolean closing = false;

        public DelegationHandler(SelectableChannel ch, ByteBuffer read, ByteBuffer write, SelectionWorker selector) throws IOException {
            this.key = selector.register(ch, 1, this);
            this.read = read;
            this.write = write;
        }

        public DelegationHandler(SelectionKey key, ByteBuffer read, ByteBuffer write) {
            this.key = key;
            this.key.attach(this);
            this.addOps(1);
            this.read = read;
            this.write = write;
        }

        public void setAnother(DelegationHandler another) {
            this.another = another;
        }

        @Override
        public void onRead(ReadableByteChannel ch) {
            try {
                LOGGER.finer(this.getClass(), "onRead", "Read from {0} and write to {1}", ch, this.read);
                this.read.clear();
                int ret = ch.read(this.read);
                if (ret == -1) {
                    this.removeOps(1);
                    this.readyToClose();
                } else if (ret > 0) {
                    this.read.flip();
                    this.removeOps(1);
                    if (this.another != null) {
                        this.another.addOps(4);
                    }
                    this.key.selector().wakeup();
                }
            }
            catch (IOException e) {
                LOGGER.warning(this.getClass(), "onRead", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, this.getClass(), "onRead", (Throwable)e);
                this.removeOps(1);
                this.readyToClose();
            }
        }

        @Override
        public void onWrite(WritableByteChannel ch) {
            try {
                LOGGER.finer(this.getClass(), "onWrite", "Read from {0} and write to {1}", this.write, ch);
                ch.write(this.write);
                if (this.write.limit() - this.write.position() == 0) {
                    this.removeOps(4);
                    if (this.another != null) {
                        this.another.addOps(1);
                    }
                    this.key.selector().wakeup();
                }
            }
            catch (IOException e) {
                LOGGER.warning(this.getClass(), "onWrite", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, this.getClass(), "onWrite", (Throwable)e);
                this.removeOps(4);
                this.another.readyToClose();
            }
        }

        @Override
        public void close() {
            LOGGER.fine(this.getClass(), "close", "Close the delegation. (key = {0})", this.key);
            this.key.interestOps(0);
            this.key.cancel();
            this.key.attach(null);
            try {
                this.key.channel().close();
            }
            catch (IOException e) {
                LOGGER.warning("close", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "close", e);
            }
        }

        private void addOps(int ops) {
            if (this.key.isValid()) {
                this.key.interestOps(this.key.interestOps() | ops);
            }
        }

        private void removeOps(int ops) {
            if (this.key.isValid()) {
                this.key.interestOps(this.key.interestOps() & ~ops);
            }
        }

        private void readyToClose() {
            if (this.another.closing) {
                this.close();
                this.another.close();
            } else {
                this.closing = true;
            }
        }
    }
}

