/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.proxyserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import nor.http.HeaderName;
import nor.http.HttpBody;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.InternalServerErrorException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.log.Logger;

public class ProxyRequestHandler
implements HttpRequestHandler {
    private final String name;
    private final String version;
    private final Router router;
    private static final int Timeout;
    private static final String Close = "close";
    private static final String VIA_FORMAT = "%s %s";
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(ProxyRequestHandler.class);
        String classname = ProxyRequestHandler.class.getName();
        Timeout = Integer.valueOf(System.getProperty(String.format("%s.Timeout", classname)));
        LOGGER.config("<init>", "Load a constant: Timeout = {0}", Timeout);
    }

    public ProxyRequestHandler(String name, String version, Router router) {
        LOGGER.entering("<init>", name, version, router);
        assert (name != null && name.length() != 0);
        assert (version != null);
        assert (router != null);
        this.name = name;
        this.version = version;
        this.router = router;
        HttpURLConnection.setFollowRedirects(false);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        assert (request != null);
        LOGGER.finest("doRequest", "{0}", request);
        HttpResponse response = null;
        try {
            if (Method.CONNECT.equals(request.getMethodString())) {
                throw new HttpException(Status.NotImplemented);
            }
            this.cleanHeader(request);
            URL url = new URL(request.getPath());
            Proxy proxy = this.router.query(request.getPath());
            if (proxy != Proxy.NO_PROXY) {
                LOGGER.config("doRequest", "Use the proxy; {0}", proxy);
            }
            LOGGER.fine("doRequest", "Send the {0}", request);
            HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
            con.setConnectTimeout(Timeout);
            this.sendRequest(con, request);
            response = this.receiveResponse(con, request);
            LOGGER.fine("doRequest", "Receive the {0}", response);
        }
        catch (IOException e) {
            LOGGER.warning("doRequest", "Catch a IOException({0})", e.getMessage());
            LOGGER.catched(Level.FINE, "doRequest", e);
            response = HttpException.createResponse(request, Status.InternalServerError, e);
        }
        catch (HttpException e) {
            LOGGER.warning("doRequest", "Catch a HttpException({0})", e.getMessage());
            LOGGER.catched(Level.FINE, "doRequest", e);
            response = e.createResponse(request);
        }
        this.cleanHeader(response);
        LOGGER.exiting("doRequest", response);
        return response;
    }

    private void sendRequest(HttpURLConnection con, HttpRequest request) throws HttpException {
        HttpHeader header = request.getHeader();
        HttpBody body = request.getBody();
        for (String key : header.keySet()) {
            con.addRequestProperty(key, header.get(key));
        }
        try {
            if (header.containsKey(HeaderName.ContentLength)) {
                int length = Integer.parseInt(header.get(HeaderName.ContentLength));
                con.setFixedLengthStreamingMode(length);
                con.setDoOutput(true);
                con.connect();
                body.output(con.getOutputStream(), header);
            } else if (header.containsKey(HeaderName.TransferEncoding)) {
                con.setDoOutput(true);
                con.connect();
                body.output(con.getOutputStream(), header);
            } else {
                con.connect();
            }
            body.close();
        }
        catch (SocketTimeoutException e) {
            LOGGER.warning("sendRequest", e.getMessage(), new Object[0]);
            throw new HttpException(Status.RequestTimeout, (Throwable)e);
        }
        catch (ConnectException e) {
            LOGGER.warning("sendRequest", e.getMessage(), new Object[0]);
            throw new HttpException(Status.RequestTimeout, (Throwable)e);
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
    }

    private HttpResponse receiveResponse(HttpURLConnection con, HttpRequest request) throws HttpException {
        HttpResponse ret = null;
        try {
            int code = con.getResponseCode();
            InputStream resStream = null;
            if (code == -1) {
                throw new InternalServerErrorException("Recieve an invalid message.");
            }
            if (code < 400) {
                String encode;
                resStream = con.getInputStream();
                if ((con.getHeaderField(HeaderName.ContentLength.toString()) != null || con.getHeaderField(HeaderName.TransferEncoding.toString()) != null) && (encode = con.getHeaderField(HeaderName.ContentEncoding.toString())) != null) {
                    if ("gzip".equalsIgnoreCase(encode)) {
                        LOGGER.info("receiveResponse", "{0}: {1} : {2}", con, con.getResponseMessage(), con.getHeaderFields());
                        resStream = new GZIPInputStream(resStream);
                    } else if ("deflate".equalsIgnoreCase(encode)) {
                        resStream = new DeflaterInputStream(resStream);
                    }
                }
            } else {
                resStream = con.getErrorStream();
            }
            ret = request.createResponse(Status.valueOf(code), resStream);
            HttpHeader resHeader = ret.getHeader();
            Map<String, List<String>> fields = con.getHeaderFields();
            for (String key : fields.keySet()) {
                if (key == null) continue;
                for (String value : fields.get(key)) {
                    resHeader.add(key, value);
                }
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        return ret;
    }

    private void cleanHeader(HttpRequest request) {
        LOGGER.entering("cleanHeader", request);
        assert (request != null);
        HttpHeader header = request.getHeader();
        header.set(HeaderName.AcceptEncoding, "gzip, identity");
        String timeout = null;
        boolean close = false;
        if (header.containsKey(HeaderName.KeepAlive)) {
            timeout = header.get(HeaderName.KeepAlive);
        } else if (header.containsValue(HeaderName.Connection, Close)) {
            close = true;
        }
        this.removeHopByHopHeader(header);
        if (this.router.query(request.getPath()) == null && header.containsKey(HeaderName.ProxyConnection)) {
            String[] stringArray = header.get(HeaderName.ProxyConnection).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                header.remove(value.trim());
                ++n2;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        if (timeout != null) {
            header.set(HeaderName.Connection, HeaderName.KeepAlive.toString());
            header.set(HeaderName.KeepAlive, timeout);
        } else if (close) {
            header.set(HeaderName.Connection, Close);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }

    private void cleanHeader(HttpResponse response) {
        LOGGER.entering("cleanHeader", response);
        assert (response != null);
        HttpHeader header = response.getHeader();
        this.removeHopByHopHeader(header);
        if (header.containsKey(HeaderName.ProxyConnection)) {
            String[] stringArray = header.get(HeaderName.ProxyConnection).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                header.remove(value.trim());
                ++n2;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }

    private void removeHopByHopHeader(HttpHeader header) {
        if (header.containsKey(HeaderName.Connection)) {
            boolean isClose = false;
            String[] stringArray = header.get(HeaderName.Connection).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                String tvalue = value.trim();
                if (Close.equalsIgnoreCase(tvalue)) {
                    isClose = true;
                } else {
                    header.remove(value.trim());
                }
                ++n2;
            }
            header.remove(HeaderName.Connection);
            if (isClose) {
                header.set(HeaderName.Connection, Close);
            }
        }
    }
}

