/*
 * Decompiled with CFR 0.152.
 */
package nor.network;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.logging.Level;
import nor.network.SelectionEventHandler;
import nor.util.log.Logger;

public class SelectionWorker
implements Runnable,
Closeable {
    private boolean running = true;
    private final Selector selector = Selector.open();
    private static final Logger LOGGER = Logger.getLogger(SelectionWorker.class);
    private static final int Timeout;

    static {
        String classname = SelectionWorker.class.getName();
        Timeout = Integer.valueOf(System.getProperty(String.format("%s.Timeout", classname)));
        LOGGER.config("<class init>", "Load a constant: Timeout = {0}", Timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Selection Thread");
        LOGGER.finer("run", "Starts listening", new Object[0]);
        try {
            try {
                block13: while (true) {
                    if (!this.running) {
                        return;
                    }
                    try {
                        int nc = this.selector.select(Timeout);
                        LOGGER.finest("run", "Begin a selection ({0} selected keys, {1} registrated keys)", nc, this.selector.keys().size());
                        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                        while (true) {
                            Channel ch;
                            if (!iterator.hasNext()) {
                                this.selector.selectedKeys().clear();
                                LOGGER.finest("run", "Ends the selection", new Object[0]);
                                continue block13;
                            }
                            SelectionKey key = iterator.next();
                            LOGGER.finer("run", "Selected key is {0}", key);
                            SelectionEventHandler handler = (SelectionEventHandler)key.attachment();
                            if (!key.isValid()) continue;
                            if (key.isAcceptable()) {
                                ch = (ServerSocketChannel)key.channel();
                                handler.onAccept((ServerSocketChannel)ch);
                                continue;
                            }
                            if (key.isConnectable()) {
                                ch = (SocketChannel)key.channel();
                                handler.onConnect((SocketChannel)ch);
                                continue;
                            }
                            if (key.isReadable()) {
                                ch = (ReadableByteChannel)((Object)key.channel());
                                handler.onRead((ReadableByteChannel)ch);
                                continue;
                            }
                            if (!key.isWritable()) continue;
                            ch = (WritableByteChannel)((Object)key.channel());
                            handler.onWrite((WritableByteChannel)ch);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.severe("run", e.getMessage(), new Object[0]);
                        LOGGER.catched(Level.FINE, "run", e);
                        continue;
                    }
                    break;
                }
            }
            catch (CancelledKeyException e) {
                LOGGER.catched(Level.FINE, "run", e);
                try {
                    this.selector.close();
                    return;
                }
                catch (IOException e2) {
                    LOGGER.warning("run", e2.getMessage(), new Object[0]);
                    LOGGER.catched(Level.FINE, "run", e2);
                    return;
                }
            }
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOGGER.warning("run", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "run", e);
            }
        }
    }

    @Override
    public void close() {
        this.running = false;
    }

    public SelectionKey register(SelectableChannel ch, int ops, SelectionEventHandler handler) throws IOException {
        ch.configureBlocking(false);
        SelectionKey key = ch.register(this.selector, ops, handler);
        return key;
    }
}

