/*
 * Decompiled with CFR 0.152.
 */
package nor.util.log;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    private final String classname;
    private final LoggerImpl impl;

    public static <T> Logger getLogger(Class<T> type) {
        String classname = type.getName();
        LogManager m = LogManager.getLogManager();
        java.util.logging.Logger log = m.getLogger(classname);
        if (log == null || !(log instanceof LoggerImpl)) {
            Logger n = new Logger(classname);
            m.addLogger(n.impl);
            return n;
        }
        LoggerImpl impl = (LoggerImpl)log;
        return impl.getLogger();
    }

    private Logger(String classname) {
        this.classname = classname;
        this.impl = new LoggerImpl(classname);
    }

    public void entering(String method, Object ... params) {
        this.finest(method, "ENTRY {0}", params);
    }

    public void exiting(String method) {
        this.finest(method, "EXIT", new Object[0]);
    }

    public void exiting(String method, Object param) {
        this.finest(method, "EXIT {0}", param);
    }

    public void throwing(String method, Throwable e) {
        this.impl.throwing(this.classname, method, e);
    }

    public void throwing(Class<?> cls, String method, Throwable e) {
        this.impl.throwing(cls.getName(), method, e);
    }

    public void catched(Level level, String method, String msg, Throwable thrown) {
        this.impl.logp(level, this.classname, method, msg, thrown);
    }

    public void catched(Level level, String method, Throwable thrown) {
        this.catched(level, method, thrown.getMessage(), thrown);
    }

    public void catched(Level level, Class<?> cls, String method, String msg, Throwable thrown) {
        this.impl.logp(level, cls.getName(), method, msg, thrown);
    }

    public void catched(Level level, Class<?> cls, String method, Throwable thrown) {
        this.catched(level, cls, method, thrown.getMessage(), thrown);
    }

    public void severe(String method, String format, Object ... args) {
        this.impl.logp(Level.SEVERE, this.classname, method, format, args);
    }

    public void warning(String method, String format, Object ... args) {
        this.impl.logp(Level.WARNING, this.classname, method, format, args);
    }

    public void info(String method, String format, Object ... args) {
        this.impl.logp(Level.INFO, this.classname, method, format, args);
    }

    public void config(String method, String format, Object ... args) {
        this.impl.logp(Level.CONFIG, this.classname, method, format, args);
    }

    public void fine(String method, String format, Object ... args) {
        this.impl.logp(Level.FINE, this.classname, method, format, args);
    }

    public void finer(String method, String format, Object ... args) {
        this.impl.logp(Level.FINER, this.classname, method, format, args);
    }

    public void finest(String method, String format, Object ... args) {
        this.impl.logp(Level.FINEST, this.classname, method, format, args);
    }

    public void severe(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.SEVERE, cls.getName(), method, format, args);
    }

    public void warning(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.WARNING, cls.getName(), method, format, args);
    }

    public void info(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.INFO, cls.getName(), method, format, args);
    }

    public void config(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.CONFIG, cls.getName(), method, format, args);
    }

    public void fine(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.FINE, cls.getName(), method, format, args);
    }

    public void finer(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.FINER, cls.getName(), method, format, args);
    }

    public void finest(Class<?> cls, String method, String format, Object ... args) {
        this.impl.logp(Level.FINEST, cls.getName(), method, format, args);
    }

    private class LoggerImpl
    extends java.util.logging.Logger {
        public LoggerImpl(String classname) {
            super(classname, null);
        }

        public Logger getLogger() {
            return Logger.this;
        }

        @Override
        public void log(LogRecord record) {
            String msg = record.getMessage();
            record.setMessage(String.format("[%s] %s", Thread.currentThread().getName(), msg));
            super.log(record);
        }
    }
}

