/*
 * Decompiled with CFR 0.152.
 */
package nor.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.core.Config;
import nor.core.Context;
import nor.core.plugin.Plugin;
import nor.core.proxy.ProxyServer;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.server.local.TextResource;
import nor.http.server.proxyserver.ProxyRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.log.Logger;

public class Nor {
    private ProxyServer server;
    private final ProxyRequestHandler handler;
    private final Router router = new Router();
    private final File confDir;
    private final Config config;
    private final Context context = new Context();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private static final Logger LOGGER = Logger.getLogger(Nor.class);
    private static final String ConfigFileTemplate = "%s.conf";
    private static final String DefaultConfigFile = "res/default.conf";
    private static final String LoggindConfigFile = "res/logging.conf";
    private static Nor nor;

    private Nor() {
        LOGGER.entering("<init>", new Object[0]);
        Class<?> c = this.getClass();
        if (!System.getProperties().containsKey("java.util.logging.config.file")) {
            try {
                Logger.loadConfig(c.getResourceAsStream(LoggindConfigFile));
            }
            catch (SecurityException e) {
                LOGGER.warning("<init>", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "<init>", e);
            }
            catch (IOException e) {
                LOGGER.warning("<init>", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "<init>", e);
            }
        }
        Properties def = new Properties();
        try {
            def.load(c.getResourceAsStream(DefaultConfigFile));
            def.putAll((Map<?, ?>)System.getProperties());
            System.getProperties().putAll((Map<?, ?>)def);
        }
        catch (IOException e) {
            LOGGER.warning("<init>", e.getMessage(), new Object[0]);
            LOGGER.catched(Level.FINE, "<init>", e);
        }
        this.confDir = new File(String.format("./config/%s/", this.context.getHostName()));
        this.confDir.mkdirs();
        this.config = new Config(new File(this.confDir, String.format(ConfigFileTemplate, this.getClass().getCanonicalName())));
        this.handler = new ProxyRequestHandler(Nor.class.getSimpleName(), this.router);
        LOGGER.exiting("<init>");
    }

    private void init() {
        LOGGER.entering("init", new Object[0]);
        this.server = new ProxyServer(this.handler, this.router);
        for (Plugin p : ServiceLoader.load(Plugin.class)) {
            if (!this.config.isEnable(p)) continue;
            File config = new File(this.confDir, String.format(ConfigFileTemplate, p.getClass().getCanonicalName()));
            p.init(config);
            this.server.attach(p);
            this.plugins.add(p);
            LOGGER.info("init", "Loading a plugin {0}", p.getClass().getName());
        }
        String routings = this.config.get("nor.routing");
        if (routings != null) {
            Pattern pat = Pattern.compile("([^;=]+)=([^;]+)");
            Matcher m = pat.matcher(routings);
            while (m.find()) {
                try {
                    String regex = m.group(1);
                    URL url = new URL(m.group(2));
                    this.router.put(regex, url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        LOGGER.exiting("init");
    }

    private void loadPlugin(String classname) throws IllegalArgumentException {
        LOGGER.entering("loadPlugin", classname);
        try {
            Class<?> c = Class.forName(classname);
            Plugin p = (Plugin)c.newInstance();
            File config = new File(this.confDir, String.format(ConfigFileTemplate, p.getClass().getCanonicalName()));
            p.init(config);
            this.server.attach(p);
            this.plugins.add(p);
            LOGGER.info("loadPlugin", "Loading a plugin {0}", p.getClass().getName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("loadPlugin", e.getMessage(), new Object[0]);
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            LOGGER.warning("loadPlugin", e.getMessage(), new Object[0]);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("loadPlugin", e.getMessage(), new Object[0]);
            throw new IllegalArgumentException(e);
        }
        LOGGER.exiting("loadPlugin");
    }

    private void start() throws IOException {
        LOGGER.entering("start", new Object[0]);
        String addr = this.config.getListenAddress();
        int port = this.config.getListenPort();
        this.server.localResourceRoot().add(new TextResource("/nor/core/proxy.pac", this.server.getPAC(addr, port, true), "application/x-javascript-config"));
        this.server.start(addr, port);
        LOGGER.exiting("start");
    }

    private void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.server.close();
        for (Plugin p : this.plugins) {
            p.close();
        }
        LOGGER.exiting("close");
    }

    public static HttpResponse request(HttpRequest request) {
        return Nor.nor.handler.doRequest(request);
    }

    public static void main(String[] args) throws MalformedURLException {
        LOGGER.entering("main", args);
        LOGGER.info("main", "Start up...", new Object[0]);
        nor = new Nor();
        nor.init();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-r") && ++i != args.length) {
                Nor.nor.router.put(".*", new URL(args[i]));
            } else if (args[i].equals("-p") && ++i != args.length) {
                String[] stringArray = args[i].split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String classname = stringArray[n2];
                    try {
                        nor.loadPlugin(classname);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            ++i;
        }
        try {
            nor.start();
            System.in.read();
            nor.close();
        }
        catch (IOException e) {
            LOGGER.severe("main", e.getMessage(), new Object[0]);
        }
        LOGGER.info("main", "End.", new Object[0]);
        LOGGER.exiting("main");
    }
}

