/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.core.proxy.filter.ReadonlyStringFilterAdapter;

public class ReadonlyPatternMatchingFilter
extends ReadonlyStringFilterAdapter {
    private final Map<Pattern, List<MatchingEventListener>> listeners = new HashMap<Pattern, List<MatchingEventListener>>();

    @Override
    public final void update(String in) {
        for (Pattern pat : this.listeners.keySet()) {
            Matcher m = pat.matcher(in);
            while (m.find()) {
                for (MatchingEventListener l : this.listeners.get(pat)) {
                    l.update(m.toMatchResult());
                }
            }
        }
    }

    public void addEventListener(Pattern pat, MatchingEventListener listener) {
        if (this.listeners.containsKey(pat)) {
            this.listeners.get(pat).add(listener);
        } else {
            ArrayList<MatchingEventListener> list = new ArrayList<MatchingEventListener>();
            list.add(listener);
            this.listeners.put(pat, list);
        }
    }

    public void addEventListener(String regex, MatchingEventListener listener) {
        this.addEventListener(Pattern.compile(regex), listener);
    }

    public void removeEventListener(MatchingEventListener l) {
        for (Pattern pat : this.listeners.keySet()) {
            this.listeners.get(pat).remove(l);
        }
    }

    public static interface MatchingEventListener {
        public void update(MatchResult var1);
    }
}

