/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import nor.http.HeaderName;
import nor.http.Http;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.io.HeaderInputStream;
import nor.util.io.LimitedInputStream;
import nor.util.log.Logger;

public class HttpRequest
extends HttpMessage {
    private String method;
    private String path;
    private String version;
    private final HttpHeader header;
    private static final Logger LOGGER = Logger.getLogger(HttpRequest.class);

    public HttpRequest(String method, URL url) {
        this(method, url, "");
    }

    public HttpRequest(String method, URL url, String body) {
        this(method, url, new ByteArrayInputStream(body.getBytes()), body.getBytes().length);
    }

    public HttpRequest(String method, URL url, InputStream body) {
        this.method = method;
        this.path = url.toString();
        this.version = Http.Version;
        this.header = new HttpHeader();
        this.setBody(body);
    }

    public HttpRequest(String method, URL url, InputStream body, long length) {
        this.method = method;
        this.path = url.toString();
        this.version = Http.Version;
        this.header = new HttpHeader();
        this.header.set(HeaderName.ContentLength, Long.toString(length));
        this.setBody(new LimitedInputStream(body, length));
    }

    public HttpRequest(Method method, URL url) {
        this(method.toString(), url);
    }

    public HttpRequest(Method method, URL url, String body) {
        this(method.toString(), url, body);
    }

    public HttpRequest(Method method, URL url, InputStream body) {
        this(method.toString(), url, body);
    }

    private HttpRequest(InputStream input) throws IOException {
        String buf;
        LOGGER.entering("<init>", input);
        assert (input != null);
        BufferedReader in = new BufferedReader(new InputStreamReader(new HeaderInputStream(input)));
        while ((buf = in.readLine()) != null) {
            Matcher m = Http.RequestLinePattern.matcher(buf);
            if (!m.matches()) continue;
            this.method = m.group(1);
            this.path = m.group(2);
            this.version = m.group(3);
            break;
        }
        this.header = new HttpHeader(in);
        this.setBody(HttpMessage.decodeStream(input, this.header));
        LOGGER.exiting("<init>");
    }

    public String getMethodString() {
        LOGGER.entering("getMethodString", new Object[0]);
        String ret = this.method;
        LOGGER.exiting("getMethodString", (Object)ret);
        return ret;
    }

    public Method getMethod() {
        LOGGER.entering("getMethod", new Object[0]);
        Method ret = null;
        try {
            ret = Method.valueOf(this.method);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("getMethod", e.getMessage(), new Object[0]);
        }
        LOGGER.exiting("getMethod", (Object)ret);
        return ret;
    }

    public void setPath(String path) {
        LOGGER.entering("setPath", path);
        this.path = path;
        LOGGER.exiting("setPath");
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        String ret = String.format("Request[method=%s, path=%s]\r\n%s", new Object[]{this.getMethod(), this.getPath(), this.header.toString()});
        LOGGER.exiting("toString", (Object)ret);
        return ret.toString();
    }

    public HttpResponse createResponse(InputStream input) throws HttpException {
        LOGGER.entering("createResponse", input);
        assert (input != null);
        HttpResponse ret = new HttpResponse(this, input);
        LOGGER.exiting("createResponse", ret);
        return ret;
    }

    public HttpResponse createResponse(Status status, InputStream body) {
        HttpResponse ret = new HttpResponse(this, status, body);
        return ret;
    }

    public HttpResponse createResponse(Status status, InputStream body, long length) {
        HttpResponse ret = new HttpResponse(this, status, body, length);
        return ret;
    }

    public HttpResponse createResponse(Status status) {
        return this.createResponse(status, "");
    }

    public HttpResponse createResponse(Status status, String body) {
        byte[] b = body.getBytes();
        HttpResponse ret = this.createResponse(status, new ByteArrayInputStream(b), b.length);
        return ret;
    }

    @Override
    public String getVersion() {
        LOGGER.entering("getVersion", new Object[0]);
        String ret = this.version;
        LOGGER.exiting("getVersion", (Object)ret);
        return ret;
    }

    @Override
    public String getPath() {
        LOGGER.entering("getPath", new Object[0]);
        String ret = this.path;
        LOGGER.exiting("getPath", (Object)ret);
        return ret;
    }

    @Override
    public String getHeadLine() {
        LOGGER.entering("getHeadLine", new Object[0]);
        String ret = String.format(Http.RequestLineTemplate, this.method, this.path, this.version);
        LOGGER.exiting("getHeadLine", (Object)ret);
        return ret;
    }

    @Override
    public HttpHeader getHeader() {
        return this.header;
    }

    public static HttpRequest create(InputStream input) {
        HttpRequest ret;
        block3: {
            try {
                ret = new HttpRequest(input);
                if (ret.getMethodString() != null) break block3;
                return null;
            }
            catch (IOException e) {
                LOGGER.catched(Level.FINE, "create", e);
                return null;
            }
        }
        return ret;
    }
}

