/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.local;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.error.HttpException;
import nor.http.server.local.Resource;
import nor.util.log.Logger;

public class DirResource
extends Resource
implements Map<String, Resource> {
    private final Map<String, Resource> children = Collections.synchronizedMap(new HashMap());
    private static final Logger LOGGER = Logger.getLogger(DirResource.class);

    public DirResource(String name) {
        super(name);
        LOGGER.entering("<init>", name);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doDelete(String path, HttpRequest request) throws HttpException {
        String next;
        String dirname;
        LOGGER.entering("doDelete", path, request);
        HttpResponse ret = null;
        if (path.startsWith(this.getName()) && this.children.containsKey(dirname = (next = path.substring(this.getName().length() + 1)).substring(1, next.indexOf("/")))) {
            Resource r = this.children.get(dirname);
            ret = r.doDelete(next, request);
        }
        LOGGER.exiting("doDelete", ret);
        return ret;
    }

    @Override
    public HttpResponse doGet(String path, HttpRequest request) throws HttpException {
        String next;
        String dirname;
        LOGGER.entering("doGet", path, request);
        HttpResponse ret = null;
        if (path.startsWith(this.getName()) && this.children.containsKey(dirname = (next = path.substring(this.getName().length() + 1)).substring(1, next.indexOf("/")))) {
            Resource r = this.children.get(dirname);
            ret = r.doDelete(next, request);
        }
        LOGGER.exiting("doGet", ret);
        return ret;
    }

    @Override
    public HttpResponse doPost(String path, HttpRequest request) throws HttpException {
        String next;
        String dirname;
        LOGGER.entering("doPost", path, request);
        HttpResponse ret = null;
        if (path.startsWith(this.getName()) && this.children.containsKey(dirname = (next = path.substring(this.getName().length() + 1)).substring(1, next.indexOf("/")))) {
            Resource r = this.children.get(dirname);
            ret = r.doDelete(next, request);
        }
        LOGGER.exiting("doPost", ret);
        return ret;
    }

    @Override
    public HttpResponse doPut(String path, HttpRequest request) throws HttpException {
        String next;
        String dirname;
        LOGGER.entering("doPut", path, request);
        HttpResponse ret = null;
        if (path.startsWith(this.getName()) && this.children.containsKey(dirname = (next = path.substring(this.getName().length() + 1)).substring(1, next.indexOf("/")))) {
            Resource r = this.children.get(dirname);
            ret = r.doDelete(next, request);
        }
        LOGGER.exiting("doPut", ret);
        return ret;
    }

    public String toString() {
        return "DirResource : " + this.getName();
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.children.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.children.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Resource>> entrySet() {
        return this.children.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.children.equals(o);
    }

    @Override
    public Resource get(Object key) {
        return this.children.get(key);
    }

    @Override
    public int hashCode() {
        return this.children.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.children.keySet();
    }

    @Override
    public Resource put(String key, Resource value) {
        return this.children.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Resource> m) {
        this.children.putAll(m);
    }

    @Override
    public Resource remove(Object key) {
        return this.children.remove(key);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Collection<Resource> values() {
        return this.children.values();
    }
}

