/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.IOException;
import java.io.InputStream;
import nor.util.io.SequentialInputStream;

public class LimitedInputStream
extends SequentialInputStream {
    private long remains;

    public LimitedInputStream(InputStream in, long size) {
        super(in);
        this.remains = size;
    }

    @Override
    public int read() throws IOException {
        if (this.remains == 0L) {
            return -1;
        }
        --this.remains;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = -1;
        if (this.remains != 0L && (ret = this.remains > Integer.MAX_VALUE ? this.in.read(b, off, len) : this.in.read(b, off, Math.min((int)this.remains, len))) != -1) {
            this.remains -= (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = 0L;
        if (n > 0L) {
            if (n > this.remains) {
                ret = this.remains;
                this.remains = 0L;
            } else {
                ret = n;
                this.remains -= n;
            }
            this.in.skip(ret);
        }
        return ret;
    }

    @Override
    public int available() throws IOException {
        if (this.remains > Integer.MAX_VALUE) {
            return super.available();
        }
        return Math.min(super.available(), (int)this.remains);
    }

    public long remains() {
        return this.remains;
    }
}

