/*
 * Decompiled with CFR 0.152.
 */
package nor.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream {
    private final long limit;
    private long remains;
    private static final String EXCEPTION_MSG = "Over size limit (limit: %d bytes, trying: %d bytes).";

    public LimitedOutputStream(OutputStream out, long size) {
        super(out);
        this.limit = size;
        this.remains = size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.remains) {
            throw new IOException(String.format(EXCEPTION_MSG, this.limit, this.limit - this.remains + (long)len));
        }
        this.out.write(b, off, len);
        this.remains -= (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remains == 0L) {
            throw new IOException(String.format(EXCEPTION_MSG, this.limit, this.limit + 1L));
        }
        this.out.write(b);
        --this.remains;
    }

    @Override
    public void close() throws IOException {
        while (this.remains-- > 0L) {
            this.out.write(0);
        }
        super.close();
    }

    public long remains() {
        return this.remains;
    }
}

