/*
 * Decompiled with CFR 0.152.
 */
package nor.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import nor.core.plugin.Plugin;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.MessageHandlerAdapter;
import nor.http.HeaderName;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;

public class HttpsConnector
extends Plugin {
    private String urlRegex;

    public void init(File conf) {
        ArrayList<String> hosts = new ArrayList<String>();
        if (conf.exists()) {
            try {
                String buf;
                BufferedReader in = new BufferedReader(new FileReader(conf));
                while ((buf = in.readLine()) != null) {
                    hosts.add(buf);
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Class<?> c = ((Object)((Object)this)).getClass();
            try {
                String buf;
                BufferedReader in = new BufferedReader(new InputStreamReader(c.getResourceAsStream("res/hosts.default")));
                BufferedWriter out = new BufferedWriter(new FileWriter(conf));
                while ((buf = in.readLine()) != null) {
                    hosts.add(buf);
                    out.write(buf);
                    out.write("\n");
                }
                out.close();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuilder regex = new StringBuilder();
        regex.append("http://(");
        int i = 0;
        while (i != hosts.size() - 1) {
            regex.append(((String)hosts.get(i)).replace(".", "\\.").replace("*", "[^/]*").replace("(", "(?:"));
            regex.append("|");
            ++i;
        }
        regex.append(((String)hosts.get(i)).replace(".", "\\.").replace("*", "[^/]*").replace("(", "(?:"));
        regex.append(")(.*)");
        this.urlRegex = regex.toString();
    }

    public MessageHandler[] messageHandlers() {
        return new MessageHandler[]{new MessageHandlerAdapter(this.urlRegex){

            public HttpResponse doRequest(HttpRequest request, MatchResult url) {
                String host = url.group(1);
                String path = url.group(2);
                HttpResponse res = request.createResponse(Status.Found);
                if (path != null) {
                    res.getHeader().set(HeaderName.Location, String.format("https://%s%s", host, path));
                } else {
                    res.getHeader().set(HeaderName.Location, String.format("https://%s", host));
                }
                return res;
            }
        }};
    }
}

