/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.util.io.CopyingInputStream;
import nor.util.log.Logger;

class CharsetDetectingInputStream
extends FilterInputStream {
    private final Charset charset;
    private static final Pattern Char = Pattern.compile("(?:encoding=\"([\\w_\\-]+)\"|charset=([\\w_\\-]+))", 2);
    private static final Logger LOGGER = Logger.getLogger(CharsetDetectingInputStream.class);

    public CharsetDetectingInputStream(InputStream in) {
        super(in);
        CopyingInputStream cin = new CopyingInputStream(in);
        Charset c = null;
        try {
            String buf;
            BufferedReader bin = new BufferedReader(new InputStreamReader(cin));
            while ((buf = bin.readLine()) != null) {
                Matcher m = Char.matcher(buf);
                if (!m.find()) continue;
                try {
                    if (m.group(1) != null) {
                        c = Charset.forName(m.group(1));
                        break;
                    }
                    if (m.group(2) == null) break;
                    c = Charset.forName(m.group(2));
                }
                catch (IllegalCharsetNameException e) {
                    LOGGER.warning("<init>", e.getMessage(), new Object[0]);
                    LOGGER.catched(Level.FINE, "<init>", e);
                }
                break;
            }
            this.in = new SequenceInputStream(new ByteArrayInputStream(cin.getCopy()), in);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.charset = c;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

