/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.regex.Pattern;
import nor.core.plugin.Plugin;
import nor.core.proxy.LocalContentsHandlerAdapter;
import nor.core.proxy.RequestHandler;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.RequestFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.http.server.HttpServer;
import nor.http.server.local.ListResource;
import nor.http.server.nserver.HttpNServer;
import nor.http.server.proxyserver.ProxyRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.http.server.tserver.HttpTServer;
import nor.util.log.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class ProxyServer
implements Closeable {
    private final HttpServer server;
    private final RequestHandler remoteHandler;
    private final LocalContentsHandlerAdapter localHandler;
    private final Router router;
    private static final Logger LOGGER = Logger.getLogger(ProxyServer.class);

    public ProxyServer(ProxyRequestHandler handler, Router router) {
        this(handler, router, false);
    }

    public ProxyServer(ProxyRequestHandler handler, Router router, boolean useTServer) {
        LOGGER.entering("<init>", handler, router, useTServer);
        assert (handler != null);
        assert (router != null);
        this.router = router;
        this.remoteHandler = new RequestHandler(handler);
        this.localHandler = new LocalContentsHandlerAdapter();
        this.remoteHandler.attach(this.localHandler);
        this.server = useTServer ? new HttpTServer(this.remoteHandler) : new HttpNServer(this.remoteHandler);
        LOGGER.exiting("<init>");
    }

    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, port);
        assert (hostname != null && hostname.length() != 0);
        assert (port > 0);
        this.server.start(hostname, port);
        LOGGER.exiting("start");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.server.close();
        LOGGER.exiting("close");
    }

    public ListResource localResourceRoot() {
        return this.localHandler.getRoot();
    }

    public void attach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        LOGGER.entering("attach", plugin);
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            for (MessageHandler h : hs) {
                this.remoteHandler.attach(h);
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            for (RequestFilter f : rqs) {
                this.remoteHandler.attach(f);
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            for (ResponseFilter f : res) {
                this.remoteHandler.attach(f);
            }
        }
        LOGGER.exiting("attach");
    }

    public void detach(Plugin plugin) {
        ResponseFilter[] res;
        RequestFilter[] rqs;
        LOGGER.entering("detach", plugin);
        MessageHandler[] hs = plugin.messageHandlers();
        if (hs != null) {
            for (MessageHandler h : hs) {
                this.remoteHandler.detach(h);
            }
        }
        if ((rqs = plugin.requestFilters()) != null) {
            for (RequestFilter f : rqs) {
                this.remoteHandler.detach(f);
            }
        }
        if ((res = plugin.responseFilters()) != null) {
            for (ResponseFilter f : res) {
                this.remoteHandler.detach(f);
            }
        }
        LOGGER.exiting("detach");
    }

    public String getPAC(String host, int port, boolean ssh) throws IOException {
        LOGGER.entering("getPAC", host, port, ssh);
        ArrayList<Object[]> routings = new ArrayList<Object[]>();
        for (Pattern pat : this.router.keySet()) {
            InetSocketAddress addr = (InetSocketAddress)this.router.get(pat).address();
            routings.add(new Object[]{pat.pattern(), addr.getHostName(), addr.getPort()});
        }
        VelocityEngine velocity = new VelocityEngine();
        velocity.init();
        VelocityContext context = new VelocityContext();
        context.put("ssh", (Object)ssh);
        context.put("host", (Object)host);
        context.put("port", (Object)port);
        context.put("filters", (Object)this.remoteHandler.getHandlingURLPatterns());
        context.put("routings", routings);
        Class<?> c = this.getClass();
        InputStream in = c.getResourceAsStream("proxy.pac.vm");
        StringWriter out = new StringWriter();
        velocity.evaluate((Context)context, (Writer)out, "", (Reader)new BufferedReader(new InputStreamReader(in)));
        String res = out.toString();
        LOGGER.exiting("getPAC", (Object)res);
        return res;
    }

    public static void main(String[] args) {
        Router router = new Router();
        ProxyServer app = new ProxyServer(new ProxyRequestHandler("nor", router), router);
        try {
            if (args.length < 2) {
                System.err.println("Usage: <bind address> <listen port> [<external proxy url>]");
                System.exit(1);
            }
            if (args.length >= 3) {
                router.put(".*", args[2]);
            }
            app.start(args[0], Integer.parseInt(args[1]));
            System.in.read();
            app.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

