/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy.filter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import nor.core.proxy.filter.ReadonlyByteFilterAdapter;

public class StoringToFileFilter
extends ReadonlyByteFilterAdapter {
    private final File dest;
    private final File tmp;
    private final WritableByteChannel out;
    private boolean alive = true;
    private List<CloseEventListener> listeners = new ArrayList<CloseEventListener>();
    private static final String TMP = ".tmp";

    public StoringToFileFilter(File dest) throws IOException {
        this.dest = dest;
        int i = 1;
        File cand = new File(this.dest.getAbsolutePath() + TMP);
        while (cand.exists()) {
            cand = new File(String.format("%s.%d%s", this.dest.getAbsolutePath(), i++, TMP));
        }
        this.tmp = cand;
        this.out = new FileOutputStream(this.tmp).getChannel();
    }

    @Override
    public final void update(ByteBuffer in) {
        if (this.alive) {
            try {
                this.out.write(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.alive = false;
            }
        }
    }

    @Override
    public final void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.alive = false;
        }
        if (this.alive && !this.dest.exists()) {
            this.tmp.renameTo(this.dest);
        } else {
            this.tmp.delete();
        }
        for (CloseEventListener l : this.listeners) {
            l.close(this.alive);
        }
    }

    public void addListener(CloseEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CloseEventListener listener) {
        this.listeners.remove(listener);
    }

    public static void deleteTemplaryFiles(File dir) {
        File[] temps;
        for (File tmp : temps = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(StoringToFileFilter.TMP);
            }
        })) {
            tmp.delete();
        }
    }

    public static interface CloseEventListener {
        public void close(boolean var1);
    }
}

