/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType {
    public static final String UNDEFINED = "undefined";
    private String type = "undefined";
    private String subtype = "undefined";
    private final Map<String, String> parameters = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(ContentType.class.getName());
    private static final Pattern TypePatterm = Pattern.compile("([\\w\\-]+)/([\\w\\-]+)");
    private static final Pattern ParameterPattern = Pattern.compile(";\\s*([\\w\\-]+)\\s*=\\s*([\\w\\-]+)");

    public ContentType() {
        LOGGER.entering(ContentType.class.getName(), "<init>");
        LOGGER.exiting(ContentType.class.getName(), "<init>");
    }

    public ContentType(String str) {
        LOGGER.entering(ContentType.class.getName(), "<init>", str);
        this.setContentType(str);
        LOGGER.exiting(ContentType.class.getName(), "<init>");
    }

    public String getType() {
        LOGGER.entering(ContentType.class.getName(), "getMIMEType");
        String ret = this.type;
        LOGGER.exiting(ContentType.class.getName(), "getMIMEType", ret);
        return ret;
    }

    public String getSubtype() {
        LOGGER.entering(ContentType.class.getName(), "getMIMESubtype");
        String ret = this.subtype;
        LOGGER.exiting(ContentType.class.getName(), "getMIMESubtype", ret);
        return ret;
    }

    public int getParameterSize() {
        return this.parameters.size();
    }

    public Set<String> getParameterKeys() {
        return this.parameters.keySet();
    }

    public boolean containsParameterKey(String key) {
        return this.parameters.containsKey(key);
    }

    public String getParameterValue(String key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        return this.parameters.get(key);
    }

    public boolean containsParameterValue(String value) {
        return this.parameters.containsValue(value);
    }

    public String getCharset() {
        if (this.containsParameterKey("charset")) {
            return this.getParameterValue("charset");
        }
        return null;
    }

    public String toString() {
        LOGGER.entering(ContentType.class.getName(), "toString");
        StringBuilder ret = new StringBuilder();
        ret.append(this.getType());
        ret.append("/");
        ret.append(this.getSubtype());
        for (String key : this.getParameterKeys()) {
            ret.append(";");
            ret.append(key);
            ret.append("=");
            ret.append(this.getParameterValue(key));
        }
        LOGGER.exiting(ContentType.class.getName(), "toString", ret);
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContentType) {
            ContentType that = (ContentType)obj;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && ((Object)this.parameters).equals(that.parameters);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.type.hashCode() + this.subtype.hashCode() + ((Object)this.parameters).hashCode();
    }

    void setContentType(String str) {
        LOGGER.entering(ContentType.class.getName(), "setContentType", str);
        assert (str != null);
        Matcher mt = TypePatterm.matcher(str);
        if (mt.find()) {
            this.type = mt.group(1);
            this.subtype = mt.group(2);
            Matcher mp = ParameterPattern.matcher(str);
            while (mp.find()) {
                this.parameters.put(mp.group(1), mp.group(2));
            }
        }
        LOGGER.exiting(ContentType.class.getName(), "setContentType");
    }

    public final class MIMESubType {
        public static final String HTML = "html";
    }

    public final class MIMEType {
        public static final String TEXT = "text";
        public static final String MESSAGE = "message";
        public static final String APPLICATION = "application";
        public static final String IMAGE = "image";
        public static final String AUDIO = "audio";
        public static final String VIDEO = "video";
        public static final String MODEL = "model";
        public static final String MULTIPART = "multipart";
    }
}

