/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;

public class Http {
    public static final String Version;
    public static final String ServerName;
    public static final String CHUNKED = "chunked";
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    static final String RequestLineTemplate;
    static final Pattern RequestLinePattern;
    static final String ResponseLineTemplate;
    static final Pattern ResponseLinePattern;

    private Http() {
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(Http.class.getResourceAsStream("constant.conf"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        String classname = Http.class.getName();
        Version = prop.getProperty(String.format("%s.Version", classname));
        ServerName = prop.getProperty(String.format("%s.ServerName", classname));
        RequestLineTemplate = prop.getProperty(String.format("%s.RequestLineTemplate", classname));
        RequestLinePattern = Pattern.compile(prop.getProperty(String.format("%s.RequestLinePattern", classname)));
        ResponseLineTemplate = prop.getProperty(String.format("%s.ResponseLineTemplate", classname));
        ResponseLinePattern = Pattern.compile(prop.getProperty(String.format("%s.ResponseLinePattern", classname)));
    }
}

